/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.CustomRenderType;
import com.hbm.particle.ModParticles;
import com.hbm.render.CustomRenderTypes;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ParticleMukeWave
extends TextureSheetParticle {
    private float waveScale = 45.0f;

    public ParticleMukeWave(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.setSpriteFromAge(ModParticles.MUKE_WAVE_SPRITES);
        this.lifetime = 25;
    }

    public void setup(float scale, int maxAge) {
        this.waveScale = scale;
        this.lifetime = maxAge;
    }

    public void render(VertexConsumer ignored, Camera camera, float partialTicks) {
        Vec3 camPos = camera.getPosition();
        float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - camPos.x);
        float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - camPos.y);
        float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - camPos.z);
        this.alpha = Math.clamp(1.0f - ((float)this.age + partialTicks) / (float)this.lifetime, 0.0f, 1.0f);
        this.quadSize = (1.0f - (float)Math.pow(Math.E, (double)((float)this.age + partialTicks) * -0.125)) * this.waveScale;
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer consumer = bufferSource.getBuffer(CustomRenderTypes.entityAdditive(ModParticles.SHOCKWAVE));
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        consumer.addVertex(pX - 1.0f * this.quadSize, pY - 0.25f, pZ - 1.0f * this.quadSize).setUv(u1, v1).setOverlay(OverlayTexture.NO_OVERLAY).setColor(1.0f, 1.0f, 1.0f, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX - 1.0f * this.quadSize, pY - 0.25f, pZ + 1.0f * this.quadSize).setUv(u1, v0).setOverlay(OverlayTexture.NO_OVERLAY).setColor(1.0f, 1.0f, 1.0f, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX + 1.0f * this.quadSize, pY - 0.25f, pZ + 1.0f * this.quadSize).setUv(u0, v0).setOverlay(OverlayTexture.NO_OVERLAY).setColor(1.0f, 1.0f, 1.0f, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX + 1.0f * this.quadSize, pY - 0.25f, pZ - 1.0f * this.quadSize).setUv(u0, v1).setOverlay(OverlayTexture.NO_OVERLAY).setColor(1.0f, 1.0f, 1.0f, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        bufferSource.endBatch();
    }

    public ParticleRenderType getRenderType() {
        return CustomRenderType.NONE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet sprites) {
            ModParticles.MUKE_WAVE_SPRITES = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new ParticleMukeWave(level, x, y, z);
        }
    }
}

