/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.CustomRenderType;
import com.hbm.particle.ModParticles;
import com.hbm.util.old.TessColorUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleRadiationFog
extends TextureSheetParticle {
    private static final ResourceLocation RAD = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/particle/rad_fog.png");

    public ParticleRadiationFog(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.lifetime = 100 + this.random.nextInt(40);
        this.quadSize = 7.5f;
        this.bCol = 0.0f;
        this.gCol = 0.0f;
        this.rCol = 0.0f;
        this.setSpriteFromAge(ModParticles.RAD_FOG_SPRITES);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime < 400) {
            this.lifetime = 400;
        }
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        this.alpha = (float)Math.sin((double)this.age * Math.PI / 400.0) * 0.25f;
        int color = TessColorUtil.getColorRGBA_F(0.85f, 0.9f, 0.5f, this.alpha);
        Random rand = new Random(50L);
        for (int i = 0; i < 25; ++i) {
            float dX = (float)((rand.nextGaussian() - 1.0) * 2.5);
            float dY = (float)((rand.nextGaussian() - 1.0) * (double)0.15f);
            float dZ = (float)((rand.nextGaussian() - 1.0) * 2.5);
            float size = rand.nextFloat() * this.quadSize;
            float pX = (float)((double)((float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x) + dX) + rand.nextGaussian() * 0.5);
            float pY = (float)((double)((float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y) + dY) + rand.nextGaussian() * 0.5);
            float pZ = (float)((double)((float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z) + dZ) + rand.nextGaussian() * 0.5);
            this.renderQuad(consumer, camera, pX, pY, pZ, color, size);
        }
    }

    private void renderQuad(VertexConsumer consumer, Camera camera, float pX, float pY, float pZ, int color, float size) {
        float u0 = this.sprite.getU0();
        float u1 = this.sprite.getU1();
        float v0 = this.sprite.getV0();
        float v1 = this.sprite.getV1();
        Vector3f l = new Vector3f((Vector3fc)camera.getLeftVector()).mul(size);
        Vector3f u = new Vector3f((Vector3fc)camera.getUpVector()).mul(size);
        consumer.addVertex(pX - l.x - u.x, pY - l.y - u.y, pZ - l.z - u.z).setColor(color).setUv(u1, v1).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX - l.x + u.x, pY - l.y + u.y, pZ - l.z + u.z).setColor(color).setUv(u1, v0).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX + l.x + u.x, pY + l.y + u.y, pZ + l.z + u.z).setColor(color).setUv(u0, v0).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX + l.x - u.x, pY + l.y - u.y, pZ + l.z - u.z).setColor(color).setUv(u0, v1).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
    }

    public ParticleRenderType getRenderType() {
        return CustomRenderType.FOG;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet spriteSet) {
            ModParticles.RAD_FOG_SPRITES = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleRadiationFog(level, x, y, z);
        }
    }
}

