/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.CustomRenderType;
import com.hbm.particle.ModParticles;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RBMKMushParticle
extends TextureSheetParticle {
    public RBMKMushParticle(ClientLevel level, double x, double y, double z, float size) {
        super(level, x, y, z);
        this.setSpriteFromAge(ModParticles.RBMK_MUSH_SPRITES);
        this.lifetime = 50;
        this.quadSize = size;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.setSpriteFromAge(ModParticles.RBMK_MUSH_SPRITES);
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x);
        float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y) + this.quadSize;
        float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z);
        Vector3f up = new Vector3f((Vector3fc)camera.getUpVector());
        Vector3f left = new Vector3f((Vector3fc)camera.getLeftVector());
        this.renderQuad(consumer, pX, pY, pZ, up, left, this.quadSize);
    }

    private void renderQuad(VertexConsumer consumer, float pX, float pY, float pZ, Vector3f up, Vector3f left, float scale) {
        float u0 = this.sprite.getU0();
        float u1 = this.sprite.getU1();
        float v0 = this.sprite.getV0();
        float v1 = this.sprite.getV1();
        Vector3f l = new Vector3f((Vector3fc)left).mul(scale);
        Vector3f u = new Vector3f((Vector3fc)up).mul(scale);
        consumer.addVertex(pX - l.x - u.x, pY - l.y - u.y, pZ - l.z - u.z).setUv(u1, v1).setColor(this.rCol, this.bCol, this.gCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX - l.x + u.x, pY - l.y + u.y, pZ - l.z + u.z).setUv(u1, v0).setColor(this.rCol, this.bCol, this.gCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX + l.x + u.x, pY + l.y + u.y, pZ + l.z + u.z).setUv(u0, v0).setColor(this.rCol, this.bCol, this.gCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX + l.x - u.x, pY + l.y - u.y, pZ + l.z - u.z).setUv(u0, v1).setColor(this.rCol, this.bCol, this.gCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
    }

    public ParticleRenderType getRenderType() {
        return CustomRenderType.PARTICLE_SHEET_ADDITIVE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet sprites) {
            ModParticles.RBMK_MUSH_SPRITES = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RBMKMushParticle(level, x, y, z, 10.0f);
        }
    }
}

