/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.CustomRenderType;
import com.hbm.particle.ModParticles;
import com.hbm.particle.helper.SkeletonCreator;
import com.hbm.render.entity.effect.SkeletonModel;
import com.hbm.util.old.TessColorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SkeletonParticle
extends TextureSheetParticle {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/particle/skeleton.png");
    public static final ResourceLocation TEXTURE_EXT = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/particle/skoilet.png");
    public static final ResourceLocation TEXTURE_BLOOD = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/particle/skeleton_blood.png");
    public static final ResourceLocation TEXTURE_BLOOD_EXT = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/particle/skoilet_blood.png");
    protected SkeletonCreator.EnumSkeletonType type;
    public ResourceLocation useTexture;
    public ResourceLocation useTextureExt;
    private float momentumYaw;
    private float momentumPitch;
    private int initialDelay;
    public double prevRotationPitch;
    public double prevRotationYaw;
    public double rotationPitch;
    public double rotationYaw;
    private SkeletonModel model;
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.square((int)100);

    public SkeletonParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, SkeletonCreator.EnumSkeletonType type) {
        super(level, x, y, z);
        this.setSpriteFromAge(ModParticles.BASE_PARTICLE_SPRITES);
        this.type = type;
        this.lifetime = 300 + this.random.nextInt(20);
        this.rCol = r;
        this.gCol = g;
        this.bCol = b;
        this.gravity = 0.02f;
        this.initialDelay = 20;
        this.momentumPitch = this.random.nextFloat() * 5.0f * (float)(this.random.nextBoolean() ? 1 : -1);
        this.momentumYaw = this.random.nextFloat() * 5.0f * (float)(this.random.nextBoolean() ? 1 : -1);
        this.useTexture = TEXTURE;
        this.useTextureExt = TEXTURE_EXT;
        this.model = new SkeletonModel(Minecraft.getInstance().getEntityModels().bakeLayer(SkeletonModel.SKELETON_PART_LAYER));
    }

    public SkeletonParticle makeGib() {
        this.initialDelay = -2;
        this.useTexture = TEXTURE_BLOOD;
        this.useTextureExt = TEXTURE_BLOOD_EXT;
        this.gravity = 0.04f;
        this.lifetime = 600 + this.random.nextInt(20);
        return this;
    }

    public void move(double x, double y, double z) {
        double d0 = x;
        double d1 = y;
        double d2 = z;
        if (this.hasPhysics && (x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 vec3 = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec3.x;
            y = vec3.y;
            z = vec3.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = d1 != y && d1 < 0.0;
        if (this.onGround) {
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
        } else {
            if (d0 != x) {
                this.xd = 0.0;
            }
            if (d2 != z) {
                this.zd = 0.0;
            }
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.prevRotationPitch = this.rotationPitch;
        this.prevRotationYaw = this.rotationYaw;
        if (this.initialDelay-- > 0) {
            return;
        }
        if (this.initialDelay == -1) {
            this.xd = this.random.nextGaussian() * 0.025;
            this.zd = this.random.nextGaussian() * 0.025;
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        boolean wasOnGround = this.onGround;
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        if (!this.onGround) {
            this.rotationPitch += (double)this.momentumPitch;
            this.rotationYaw += (double)this.momentumYaw;
        } else {
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
            if (!wasOnGround) {
                this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.SKELETON_HURT, SoundSource.AMBIENT, 0.25f, 0.8f + this.random.nextFloat() * 0.4f, false);
            }
        }
    }

    public void render(VertexConsumer ignored, Camera camera, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        Vec3 camPos = camera.getPosition();
        float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - camPos.x);
        float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - camPos.y);
        float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - camPos.z);
        poseStack.pushPose();
        poseStack.translate(pX, pY, pZ);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)(-Mth.lerp((double)partialTicks, (double)this.prevRotationYaw, (double)this.rotationYaw))));
        poseStack.mulPose(Axis.XP.rotationDegrees((float)(-Mth.lerp((double)partialTicks, (double)this.prevRotationPitch, (double)this.rotationPitch))));
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        ResourceLocation textureToUse = this.getTexture(this.type);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)textureToUse));
        float timeLeft = (float)this.lifetime - ((float)this.age + partialTicks);
        this.alpha = timeLeft < 40.0f ? timeLeft / 40.0f : 1.0f;
        int color = TessColorUtil.getColorRGBA_F(this.rCol, this.gCol, this.bCol, this.alpha);
        this.model.render(poseStack, consumer, this.getLightColor(partialTicks), OverlayTexture.NO_OVERLAY, color, this.type);
        buffer.endBatch();
        poseStack.popPose();
    }

    private ResourceLocation getTexture(SkeletonCreator.EnumSkeletonType type) {
        boolean usingNormal = this.useTexture.equals((Object)TEXTURE);
        boolean usingNormalVill = this.useTextureExt.equals((Object)TEXTURE_EXT);
        if (type == SkeletonCreator.EnumSkeletonType.SKULL_VILLAGER) {
            return usingNormalVill ? TEXTURE_EXT : TEXTURE_BLOOD_EXT;
        }
        return usingNormal ? TEXTURE : TEXTURE_BLOOD;
    }

    public ParticleRenderType getRenderType() {
        return CustomRenderType.NONE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public TextureSheetParticle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            int use = level.random.nextInt(4);
            SkeletonCreator.EnumSkeletonType skeletonType = switch (use) {
                case 0 -> SkeletonCreator.EnumSkeletonType.LIMB;
                case 1 -> SkeletonCreator.EnumSkeletonType.SKULL;
                case 2 -> SkeletonCreator.EnumSkeletonType.TORSO;
                case 3 -> SkeletonCreator.EnumSkeletonType.SKULL_VILLAGER;
                default -> throw new IllegalStateException("Unexpected value: " + use);
            };
            return new SkeletonParticle(level, x, y, z, 1.0f, 1.0f, 1.0f, skeletonType);
        }
    }
}

