/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.blockentity;

import com.hbm.blockentity.bomb.NukeFatManBlockEntity;
import com.hbm.blocks.bomb.NukeManBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderNukeFatMan
implements BlockEntityRenderer<NukeFatManBlockEntity> {
    private final BlockRenderDispatcher renderDispatcher;

    public RenderNukeFatMan(BlockEntityRendererProvider.Context context) {
        this.renderDispatcher = context.getBlockRenderDispatcher();
    }

    public void render(NukeFatManBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Direction facing = (Direction)be.getBlockState().getValue((Property)NukeManBlock.FACING);
        float rot = switch (facing) {
            case Direction.EAST -> 90.0f;
            case Direction.NORTH -> 180.0f;
            case Direction.WEST -> 270.0f;
            default -> 0.0f;
        };
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(rot));
        BlockState state = be.getBlockState();
        BakedModel model = this.renderDispatcher.getBlockModel(state);
        this.renderDispatcher.getModelRenderer().renderModel(poseStack.last(), buffer.getBuffer(RenderType.cutout()), state, model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(NukeFatManBlockEntity blockEntity) {
        return true;
    }
}

