/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.effect;

import com.hbm.entity.logic.DeathBlast;
import com.hbm.util.Vec3NT;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class RenderDeathBlast
extends EntityRenderer<DeathBlast> {
    private static final int STACKS = 16;
    private static final int SLICES = 16;

    public RenderDeathBlast(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(DeathBlast blast, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        BufferBuilder buffer;
        int i;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = poseStack.last().pose();
        Tesselator tess = Tesselator.getInstance();
        Vec3NT vector = new Vec3NT(0.5, 0.0, 0.0);
        for (i = 0; i < 8; ++i) {
            buffer = tess.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex(matrix, (float)vector.xCoord, 250.0f, (float)vector.zCoord).setColor(1.0f, 0.0f, 0.0f, 1.0f);
            buffer.addVertex(matrix, (float)vector.xCoord, 0.0f, (float)vector.zCoord).setColor(1.0f, 0.0f, 0.0f, 1.0f);
            vector.rotateAroundYRad(45.0);
            buffer.addVertex(matrix, (float)vector.xCoord, 0.0f, (float)vector.zCoord).setColor(1.0f, 0.0f, 0.0f, 1.0f);
            buffer.addVertex(matrix, (float)vector.xCoord, 250.0f, (float)vector.zCoord).setColor(1.0f, 0.0f, 0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        }
        for (i = 0; i < 8; ++i) {
            buffer = tess.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex(matrix, (float)vector.xCoord / 2.0f, 250.0f, (float)vector.zCoord / 2.0f).setColor(1.0f, 0.0f, 1.0f, 1.0f);
            buffer.addVertex(matrix, (float)vector.xCoord / 2.0f, 0.0f, (float)vector.zCoord / 2.0f).setColor(1.0f, 0.0f, 1.0f, 1.0f);
            vector.rotateAroundYRad(45.0);
            buffer.addVertex(matrix, (float)vector.xCoord / 2.0f, 0.0f, (float)vector.zCoord / 2.0f).setColor(1.0f, 0.0f, 1.0f, 1.0f);
            buffer.addVertex(matrix, (float)vector.xCoord / 2.0f, 250.0f, (float)vector.zCoord / 2.0f).setColor(1.0f, 0.0f, 1.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        this.renderSphereWrapper(blast, poseStack, partialTicks);
    }

    private void renderSphereWrapper(DeathBlast blast, PoseStack poseStack, float partialTicks) {
        poseStack.pushPose();
        double maxAge = 60.0;
        double tickProgress = (double)((float)blast.tickCount + partialTicks) / maxAge;
        double scale = 10.0 - 10.0 * tickProgress;
        float alpha = (float)tickProgress;
        if (scale < 0.0) {
            scale = 0.0;
        }
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        this.renderSphere(poseStack.last().pose(), 1.0f, 1.0f, 0.0f, 1.0f, alpha);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        poseStack.scale(1.25f, 1.25f, 1.25f);
        for (int i = 0; i < 8; ++i) {
            this.renderSphere(poseStack.last().pose(), 1.0f, 1.0f, 0.0f, 0.0f, alpha * 0.125f);
            poseStack.scale(1.05f, 1.05f, 1.05f);
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    private void renderSphere(Matrix4f matrix4f, float radius, float r, float g, float b, float a) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        int colorR = (int)(r * 255.0f);
        int colorG = (int)(g * 255.0f);
        int colorB = (int)(b * 255.0f);
        int colorA = (int)(a * 255.0f);
        for (int i = 0; i < 16; ++i) {
            double phi1 = Math.PI * (double)i / 16.0;
            double phi2 = Math.PI * (double)(i + 1) / 16.0;
            for (int j = 0; j < 16; ++j) {
                double theta1 = Math.PI * 2 * (double)j / 16.0;
                double theta2 = Math.PI * 2 * (double)(j + 1) / 16.0;
                float x1 = (float)((double)radius * Math.sin(phi1) * Math.cos(theta1));
                float y1 = (float)((double)radius * Math.cos(phi1));
                float z1 = (float)((double)radius * Math.sin(phi1) * Math.sin(theta1));
                float x2 = (float)((double)radius * Math.sin(phi2) * Math.cos(theta1));
                float y2 = (float)((double)radius * Math.cos(phi2));
                float z2 = (float)((double)radius * Math.sin(phi2) * Math.sin(theta1));
                float x3 = (float)((double)radius * Math.sin(phi2) * Math.cos(theta2));
                float y3 = (float)((double)radius * Math.cos(phi2));
                float z3 = (float)((double)radius * Math.sin(phi2) * Math.sin(theta2));
                float x4 = (float)((double)radius * Math.sin(phi1) * Math.cos(theta2));
                float y4 = (float)((double)radius * Math.cos(phi1));
                float z4 = (float)((double)radius * Math.sin(phi1) * Math.sin(theta2));
                buffer.addVertex(matrix4f, x1, y1, z1).setColor(colorR, colorG, colorB, colorA);
                buffer.addVertex(matrix4f, x2, y2, z2).setColor(colorR, colorG, colorB, colorA);
                buffer.addVertex(matrix4f, x3, y3, z3).setColor(colorR, colorG, colorB, colorA);
                buffer.addVertex(matrix4f, x1, y1, z1).setColor(colorR, colorG, colorB, colorA);
                buffer.addVertex(matrix4f, x3, y3, z3).setColor(colorR, colorG, colorB, colorA);
                buffer.addVertex(matrix4f, x4, y4, z4).setColor(colorR, colorG, colorB, colorA);
            }
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public ResourceLocation getTextureLocation(DeathBlast deathBlast) {
        return null;
    }

    public boolean shouldRender(DeathBlast livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }
}

