/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.effect;

import com.hbm.particle.helper.SkeletonCreator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class SkeletonModel {
    public static ModelLayerLocation SKELETON_PART_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"particle_skeleton_part"), "main");
    private final ModelPart root;

    public SkeletonModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partDefinition = mesh.getRoot();
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("limb", CubeListBuilder.create().texOffs(40, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("head_villager", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void render(PoseStack pose, VertexConsumer buffer, int brightness, int overlay, int color, SkeletonCreator.EnumSkeletonType type) {
        switch (type) {
            case SKULL: {
                this.root.getChild("head").render(pose, buffer, brightness, overlay, color);
                break;
            }
            case LIMB: {
                this.root.getChild("limb").render(pose, buffer, brightness, overlay, color);
                break;
            }
            case TORSO: {
                this.root.getChild("torso").render(pose, buffer, brightness, overlay, color);
                break;
            }
            case SKULL_VILLAGER: {
                this.root.getChild("head_villager").render(pose, buffer, brightness, overlay, color);
            }
        }
    }
}

