/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.projectile;

import com.hbm.entity.projectile.Shrapnel;
import com.hbm.render.entity.projectile.ModelShrapnel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class RenderMissileTEST
extends EntityRenderer<Entity> {
    private static final ResourceLocation SHRAPNEL = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/entity/shrapnel.png");
    private final ModelShrapnel<Shrapnel> model;

    public RenderMissileTEST(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelShrapnel(context.bakeLayer(ModelShrapnel.LAYER_LOCATION));
    }

    public void render(Entity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(1.0f, 1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(entity.yRotO + (entity.getYRot() - entity.yRotO) * partialTicks - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(entity.xRotO + (entity.getXRot() - entity.xRotO) * partialTicks));
        poseStack.mulPose(Axis.YN.rotationDegrees(entity.yRotO + (entity.getYRot() - entity.yRotO) * partialTicks - 90.0f));
        poseStack.scale(3.0f, 10.0f, 3.0f);
        VertexConsumer vertexconsumer = buffer.getBuffer(this.model.renderType(this.getTextureLocation(entity)));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(Entity test) {
        return SHRAPNEL;
    }
}

