/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.config.MainConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderInfoSystem {
    private static int nextID = 1000;
    private static final Map<Integer, InfoEntry> inbox = new HashMap<Integer, InfoEntry>();
    private static final Map<Integer, InfoEntry> messages = new HashMap<Integer, InfoEntry>();

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Post event) {
        messages.putAll(inbox);
        inbox.clear();
        ArrayList<Integer> keys = new ArrayList<Integer>(messages.keySet());
        long now = System.currentTimeMillis();
        for (int i = 0; i < keys.size(); ++i) {
            Integer key = (Integer)keys.get(i);
            InfoEntry entry = messages.get(key);
            if (entry == null || entry.start + (long)entry.millis >= now) continue;
            messages.remove(key);
            keys = new ArrayList<Integer>(messages.keySet());
            --i;
        }
    }

    @SubscribeEvent
    public static void onOverlayRender(RenderGuiEvent.Pre event) {
        int pX;
        if (messages.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        int width = mc.getWindow().getGuiScaledWidth();
        int height = mc.getWindow().getGuiScaledHeight();
        ArrayList<InfoEntry> entries = new ArrayList<InfoEntry>(messages.values());
        Collections.sort(entries);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        int longest = 0;
        for (InfoEntry entry : messages.values()) {
            int length = mc.font.width((FormattedText)entry.component);
            if (length <= longest) continue;
            longest = length;
        }
        int mode = (Integer)MainConfig.CLIENT.INFO_POSITION.get();
        int n = mode == 0 ? 15 : (mode == 1 ? width - longest - 15 : (pX = mode == 2 ? width / 2 + 7 : width / 2 - longest - 6));
        int pZ = mode == 0 ? 15 : (mode == 1 ? 15 : height / 2 + 7);
        int side = (pX += ((Integer)MainConfig.CLIENT.INFO_OFFSET_HORIZONTAL.get()).intValue()) + 5 + longest;
        int infoHeight = messages.size() * 10 + (pZ += ((Integer)MainConfig.CLIENT.INFO_OFFSET_VERTICAL.get()).intValue()) + 2;
        boolean z = false;
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buf.addVertex((float)(pX - 5), (float)(pZ - 5), (float)z).setColor(0.25f, 0.25f, 0.25f, 0.5f);
        buf.addVertex((float)(pX - 5), (float)infoHeight, (float)z).setColor(0.25f, 0.25f, 0.25f, 0.5f);
        buf.addVertex((float)side, (float)infoHeight, (float)z).setColor(0.25f, 0.25f, 0.25f, 0.5f);
        buf.addVertex((float)side, (float)(pZ - 5), (float)z).setColor(0.25f, 0.25f, 0.25f, 0.5f);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        int off = 0;
        long now = System.currentTimeMillis();
        for (InfoEntry entry : messages.values()) {
            int elapsed = (int)(now - entry.start);
            int alpha = Math.max(Math.min(510 * (entry.millis - elapsed) / entry.millis, 255), 5);
            graphics.drawString(mc.font, entry.component, pX, pZ + off, 0xFFFFFF | alpha << 24);
            off += 10;
        }
    }

    public static void push(InfoEntry entry) {
        RenderInfoSystem.push(entry, nextID++);
    }

    public static void push(InfoEntry entry, int id) {
        inbox.put(id, entry);
    }

    public static class InfoEntry
    implements Comparable<InfoEntry> {
        Component component;
        long start;
        int millis;

        public InfoEntry(Component component, int millis) {
            this.component = component;
            this.millis = millis;
            this.start = System.currentTimeMillis();
        }

        public InfoEntry(Component component) {
            this(component, 3000);
        }

        @Override
        public int compareTo(InfoEntry other) {
            return Integer.compare(this.millis, other.millis);
        }
    }
}

