/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata;

import com.hbm.saveddata.satellite.Satellite;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class SatelliteSavedData
extends SavedData {
    public static final String NAME = "satellites";
    public final Map<Integer, Satellite> sats = new HashMap<Integer, Satellite>();

    public static SavedData.Factory<SatelliteSavedData> factory() {
        return new SavedData.Factory(SatelliteSavedData::new, SatelliteSavedData::load);
    }

    private SatelliteSavedData() {
        this.setDirty();
    }

    public static SatelliteSavedData load(CompoundTag tag, HolderLookup.Provider registries) {
        SatelliteSavedData data = new SatelliteSavedData();
        int satCount = tag.getInt("satCount");
        for (int i = 0; i < satCount; ++i) {
            int id = tag.getInt("sat_id_" + i);
            int freq = tag.getInt("sat_freq_" + i);
            CompoundTag satTag = tag.getCompound("sat_data_" + i);
            Satellite sat = Satellite.create(id);
            sat.readFromNBT(satTag);
            data.sats.put(freq, sat);
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("satCount", this.sats.size());
        int i = 0;
        for (Map.Entry<Integer, Satellite> entry : this.sats.entrySet()) {
            Satellite sat = entry.getValue();
            CompoundTag satTag = new CompoundTag();
            sat.writeToNBT(satTag);
            tag.putInt("sat_id_" + i, sat.getID());
            tag.put("sat_data_" + i, (Tag)satTag);
            tag.putInt("sat_freq_" + i, entry.getKey().intValue());
            ++i;
        }
        return tag;
    }

    public boolean isFreqTaken(int freq) {
        return this.sats.containsKey(freq);
    }

    public Satellite getSatFromFreq(int freq) {
        return this.sats.get(freq);
    }

    public void putSatellite(int freq, Satellite sat) {
        this.sats.put(freq, sat);
        this.setDirty();
    }

    public void removeSatellite(int freq) {
        if (this.sats.remove(freq) != null) {
            this.setDirty();
        }
    }

    public static SatelliteSavedData get(ServerLevel level) {
        return (SatelliteSavedData)level.getDataStorage().computeIfAbsent(SatelliteSavedData.factory(), NAME);
    }
}

