/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata.satellite;

import com.hbm.items.ModItems;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellite.SatelliteLaser;
import com.hbm.saveddata.satellite.SatelliteRadar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public abstract class Satellite {
    public static final List<Class<? extends Satellite>> SATELLITES = new ArrayList<Class<? extends Satellite>>();
    public static final HashMap<Item, Class<? extends Satellite>> ITEM_TO_CLASS = new HashMap();
    public List<InterfaceActions> ifaceAcs = new ArrayList<InterfaceActions>();
    public List<CoordActions> coordAcs = new ArrayList<CoordActions>();
    public Interfaces satIface = Interfaces.NONE;

    public static void register() {
        Satellite.registerSatellite(SatelliteLaser.class, (Item)ModItems.SATELLITE_LASER.get());
        Satellite.registerSatellite(SatelliteRadar.class, (Item)ModItems.SATELLITE_RADAR.get());
    }

    public static void registerSatellite(Class<? extends Satellite> sat, Item item) {
        if (!ITEM_TO_CLASS.containsKey(item) && !ITEM_TO_CLASS.containsValue(sat)) {
            SATELLITES.add(sat);
            ITEM_TO_CLASS.put(item, sat);
        }
    }

    public static void orbit(ServerLevel serverLevel, int id, int freq, double x, double y, double z) {
        Satellite sat = Satellite.create(id);
        if (sat != null) {
            SatelliteSavedData data = SatelliteSavedData.get(serverLevel);
            data.sats.put(freq, sat);
            sat.onOrbit((Level)serverLevel, x, y, z);
            data.setDirty();
        }
    }

    public static Satellite create(int id) {
        Satellite sat = null;
        try {
            Class<? extends Satellite> c = SATELLITES.get(id);
            sat = c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sat;
    }

    public static int getIDFromItem(Item item) {
        Class<? extends Satellite> sat = ITEM_TO_CLASS.get(item);
        return SATELLITES.indexOf(sat);
    }

    public int getID() {
        return SATELLITES.indexOf(this.getClass());
    }

    public void writeToNBT(CompoundTag tag) {
    }

    public void readFromNBT(CompoundTag tag) {
    }

    public void onOrbit(Level level, double x, double y, double z) {
    }

    public void onClick(Level level, int x, int z) {
    }

    public void onCoordAction(Level level, Player player, BlockPos pos) {
    }

    public static enum Interfaces {
        NONE,
        SAT_PANEL,
        SAT_COORD;

    }

    public static enum CoordActions {
        HAS_Y;

    }

    public static enum InterfaceActions {
        HAS_MAP,
        CAN_CLICK,
        SHOW_COORDS,
        HAS_RADAR,
        HAS_ORES;

    }
}

