/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.item.IGasMask;
import com.hbm.handler.ArmorModHandler;
import com.hbm.util.ArmorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorRegistry {
    public static HashMap<Item, ArrayList<HazardClass>> hazardClasses = new HashMap();

    public static void registerHazard(Item item, HazardClass ... hazards) {
        hazardClasses.put(item, new ArrayList<HazardClass>(Arrays.asList(hazards)));
    }

    public static void addTooltip(List<Component> components, ItemStack stack) {
        List hazInfo = hazardClasses.get(stack.getItem());
        if (hazInfo != null) {
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"hazard.protect").withStyle(ChatFormatting.GOLD));
                for (HazardClass clazz : hazInfo) {
                    components.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)clazz.unlocalizedMessage)).withStyle(ChatFormatting.YELLOW));
                }
            } else {
                components.add((Component)Component.literal((String)"Hold <").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).append((Component)Component.literal((String)"LSHIFT").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})).append((Component)Component.literal((String)"> to display protection info").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
            }
        }
    }

    public static boolean hasAllProtection(LivingEntity entity, EquipmentSlot slot, HazardClass ... clazz) {
        if (ArmorUtil.checkArmorEmpty(entity, slot)) {
            return false;
        }
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(entity.getItemBySlot(slot), entity);
        return new HashSet<HazardClass>(list).containsAll(Arrays.asList(clazz));
    }

    public static boolean hasAnyProtection(LivingEntity entity, EquipmentSlot slot, HazardClass ... clazz) {
        if (ArmorUtil.checkArmorEmpty(entity, slot)) {
            return false;
        }
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(entity.getItemBySlot(slot), entity);
        if (list == null) {
            return false;
        }
        for (HazardClass haz : clazz) {
            if (!list.contains((Object)haz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasProtection(LivingEntity entity, EquipmentSlot slot, HazardClass clazz) {
        if (ArmorUtil.checkArmorEmpty(entity, slot)) {
            return false;
        }
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(entity.getItemBySlot(slot), entity);
        if (list == null) {
            return false;
        }
        return list.contains((Object)clazz);
    }

    public static List<HazardClass> getProtectionFromItem(ItemStack stack, LivingEntity entity) {
        IGasMask gasMask;
        ItemStack filter;
        ArrayList<HazardClass> prot = new ArrayList<HazardClass>();
        Item item = stack.getItem();
        if (hazardClasses.containsKey(item)) {
            prot.addAll((Collection)hazardClasses.get(item));
        }
        if (item instanceof IGasMask && !(filter = (gasMask = (IGasMask)item).getFilter(stack, entity)).isEmpty()) {
            List filProt = (List)hazardClasses.get(filter.getItem()).clone();
            for (HazardClass clazz : gasMask.getBlacklist(stack, entity)) {
                filProt.remove((Object)clazz);
            }
            prot.addAll(filProt);
        }
        if (ArmorModHandler.hasMods(stack)) {
            ItemStack[] mods;
            for (ItemStack mod : mods = ArmorModHandler.pryMods(entity.level(), stack)) {
                if (mod.isEmpty()) continue;
                prot.addAll(ArmorRegistry.getProtectionFromItem(mod, entity));
            }
        }
        return prot;
    }

    public static enum HazardClass {
        GAS_LUNG("hazard.gas_chlorine"),
        GAS_MONOXIDE("hazard.gas_monoxide"),
        GAS_INERT("hazard.gas_inert"),
        PARTICLE_COARSE("hazard.particle_coarse"),
        PARTICLE_FINE("hazard.particle_fine"),
        BACTERIA("hazard.bacteria"),
        GAS_BLISTERING("hazard.corrosive"),
        SAND("hazard.sand"),
        LIGHT("hazard.light");

        public final String unlocalizedMessage;

        private HazardClass(String unlocalizedMessage) {
            this.unlocalizedMessage = unlocalizedMessage;
        }
    }
}

