/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.item.IGasMask;
import com.hbm.handler.ArmorModHandler;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.TagsUtilDegradation;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class ArmorUtil {
    public static final String FILTER_KEY = "hfr_Filter";

    public static void register() {
        ArmorRegistry.registerHazard(Items.DIAMOND_HELMET, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.GAS_LUNG);
    }

    public static boolean checkArmor(LivingEntity entity, Item ... armor) {
        EquipmentSlot[] slots = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
        for (int i = 0; i < slots.length; ++i) {
            if (ArmorUtil.checkArmorPiece(entity, armor[i], slots[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean checkArmorPiece(LivingEntity entity, Item armor, EquipmentSlot slot) {
        return !ArmorUtil.checkArmorEmpty(entity, slot) && entity.getItemBySlot(slot).getItem() == armor;
    }

    public static boolean checkArmorEmpty(LivingEntity player, EquipmentSlot slot) {
        return player.getItemBySlot(slot).isEmpty();
    }

    public static void installGasMaskFilter(Level level, ItemStack mask, ItemStack filter) {
        if (mask.isEmpty() || filter.isEmpty()) {
            return;
        }
        CompoundTag tag = TagsUtilDegradation.getTag(mask);
        CompoundTag attach = new CompoundTag();
        filter.save((HolderLookup.Provider)level.registryAccess(), (Tag)attach);
        tag.put(FILTER_KEY, (Tag)attach);
        TagsUtilDegradation.putTag(mask, tag);
    }

    public static void removeFilter(ItemStack mask) {
        if (mask.isEmpty()) {
            return;
        }
        CompoundTag maskTag = TagsUtilDegradation.getTag(mask);
        if (maskTag.contains(FILTER_KEY)) {
            maskTag.remove(FILTER_KEY);
            TagsUtilDegradation.putTag(mask, maskTag);
        }
    }

    public static ItemStack getGasMaskFilterRecursively(ItemStack mask, LivingEntity entity) {
        ItemStack[] mods;
        ItemStack filter = ArmorUtil.getGasMaskFilter(entity.level(), mask);
        if (filter.isEmpty() && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(entity.level(), mask))[0].isEmpty() && mods[0].getItem() instanceof IGasMask) {
            filter = ((IGasMask)mods[0].getItem()).getFilter(mods[0], entity);
        }
        return filter;
    }

    public static ItemStack getGasMaskFilter(Level level, ItemStack mask) {
        if (mask.isEmpty()) {
            return ItemStack.EMPTY;
        }
        CompoundTag maskTag = TagsUtilDegradation.getTag(mask);
        if (!maskTag.contains(FILTER_KEY)) {
            return ItemStack.EMPTY;
        }
        CompoundTag attach = maskTag.getCompound(FILTER_KEY);
        Optional optionalStack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)attach);
        return optionalStack.orElse(ItemStack.EMPTY);
    }

    public static void damageGasMaskFilter(LivingEntity entity, int damage) {
        ItemStack[] mods;
        ItemStack mask = entity.getItemBySlot(EquipmentSlot.HEAD);
        if (mask.isEmpty()) {
            return;
        }
        if (!(mask.getItem() instanceof IGasMask) && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(entity.level(), mask))[0].isEmpty() && mods[0].getItem() instanceof IGasMask) {
            mask = mods[0];
        }
        ArmorUtil.damageGasMaskFilter(entity.level(), mask, damage);
    }

    public static void damageGasMaskFilter(Level level, ItemStack mask, int damage) {
        ItemStack[] mods;
        ItemStack filter = ArmorUtil.getGasMaskFilter(level, mask);
        if (filter.isEmpty() && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(level, mask))[0].isEmpty() && mods[0].getItem() instanceof IGasMask) {
            filter = ArmorUtil.getGasMaskFilter(level, mods[0]);
        }
        if (filter.isEmpty() || filter.getMaxDamage() == 0) {
            return;
        }
        filter.setDamageValue(filter.getDamageValue() + damage);
        if (filter.getDamageValue() > filter.getMaxDamage()) {
            ArmorUtil.removeFilter(mask);
        } else {
            ArmorUtil.installGasMaskFilter(level, mask, filter);
        }
    }

    public static boolean isWearingEmptyMask(Player player) {
        ItemStack mask = player.getItemBySlot(EquipmentSlot.HEAD);
        if (mask.isEmpty()) {
            return false;
        }
        if (mask.getItem() instanceof IGasMask) {
            return ArmorUtil.getGasMaskFilter(player.level(), mask).isEmpty();
        }
        ItemStack mod = ArmorModHandler.pryMods(player.level(), mask)[0];
        if (mod != null && mod.getItem() instanceof IGasMask) {
            return ArmorUtil.getGasMaskFilter(player.level(), mod).isEmpty();
        }
        return false;
    }
}

