/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import java.util.ArrayList;
import java.util.ListIterator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ChatBuilder {
    private final MutableComponent root;
    private MutableComponent last;

    private ChatBuilder(String text) {
        this.last = this.root = Component.literal((String)text);
    }

    public static ChatBuilder start(String text) {
        return new ChatBuilder(text);
    }

    public static ChatBuilder startTranslation(String key, Object ... args) {
        ChatBuilder builder = new ChatBuilder("");
        return builder.nextTranslation(key, args);
    }

    public ChatBuilder next(String text) {
        MutableComponent append = Component.literal((String)text);
        this.last.append((Component)append);
        this.last = append;
        return this;
    }

    public ChatBuilder nextTranslation(String key, Object ... args) {
        MutableComponent append = Component.translatable((String)key, (Object[])args);
        this.last.append((Component)append);
        this.last = append;
        return this;
    }

    public ChatBuilder color(ChatFormatting format) {
        this.last.setStyle(this.last.getStyle().withColor(format));
        return this;
    }

    public ChatBuilder colorAll(ChatFormatting format) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        list.add(this.root);
        ListIterator<MutableComponent> it = list.listIterator();
        while (it.hasNext()) {
            MutableComponent comp = (MutableComponent)it.next();
            comp.setStyle(comp.getStyle().withColor(format));
            for (Component sibling : comp.getSiblings()) {
                if (!(sibling instanceof MutableComponent)) continue;
                MutableComponent mc = (MutableComponent)sibling;
                it.add(mc);
            }
        }
        return this;
    }

    public MutableComponent flush() {
        return this.root;
    }
}

