/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.entity.IRadiationImmune;
import com.hbm.entity.mob.CreeperNuclear;
import com.hbm.entity.mob.Duck;
import com.hbm.extprop.HbmLivingAttachments;
import com.hbm.handler.HazmatRegistry;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.lib.ModEffect;
import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;

public class ContaminationUtil {
    public static HashSet<Class<?>> immuneEntities = new HashSet();

    public static boolean isRadImmune(Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(ModEffect.MUTATION)) {
            return true;
        }
        if (immuneEntities.isEmpty()) {
            immuneEntities.add(CreeperNuclear.class);
            immuneEntities.add(MushroomCow.class);
            immuneEntities.add(Zombie.class);
            immuneEntities.add(Skeleton.class);
            immuneEntities.add(Ocelot.class);
            immuneEntities.add(IRadiationImmune.class);
        }
        Class<?> entityClass = entity.getClass();
        for (Class<?> clazz : immuneEntities) {
            if (!clazz.isAssignableFrom(entityClass)) continue;
            return true;
        }
        return false;
    }

    public static void applyDigammaData(Entity entity, float dig) {
        Player player;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (entity instanceof Duck || entity instanceof Ocelot) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).isCreative()) {
            return;
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (player.tickCount < 200) {
                return;
            }
        }
        if (living.hasEffect(ModEffect.STABILITY)) {
            return;
        }
        HbmLivingAttachments.incrementDigamma(living, dig);
    }

    public static float calculateRadiationMod(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float coefficient = 10.0f;
            return (float)Math.pow(coefficient, -HazmatRegistry.getResistance(player));
        }
        return 1.0f;
    }

    public static void printGeigerData(Player player) {
        double playerRad = (double)((int)(HbmLivingAttachments.getRadiation((LivingEntity)player) * 10.0f)) / 10.0;
        double chunkRad = (double)((int)(ChunkRadiationManager.proxy.getRadiation(player.level(), player.blockPosition()) * 10.0f)) / 10.0;
        double envRad = (double)((int)((double)HbmLivingAttachments.getRadBuf((LivingEntity)player) * 10.0)) / 10.0;
        double res = (double)((int)(10000.0 - (double)ContaminationUtil.calculateRadiationMod((LivingEntity)player) * 10000.0)) / 100.0;
        double resKoeff = (double)((int)((double)HazmatRegistry.getResistance(player) * 100.0)) / 100.0;
        String playerRadPrefix = ContaminationUtil.getPrefixFromRadPlayer(playerRad);
        String chunkPrefix = ContaminationUtil.getPrefixFromRad(chunkRad);
        String envPrefix = ContaminationUtil.getPrefixFromRad(envRad);
        String resPrefix = ContaminationUtil.getPrefixFromRadResistance(resKoeff);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.title").withStyle(ChatFormatting.GOLD), false);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.chunkRad", (Object[])new Object[]{chunkPrefix + chunkRad + " RAD/s"}).withStyle(ChatFormatting.YELLOW), false);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.envRad", (Object[])new Object[]{envPrefix + envRad + " RAD/s"}).withStyle(ChatFormatting.YELLOW), false);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.playerRad", (Object[])new Object[]{playerRadPrefix + playerRad + " RAD"}).withStyle(ChatFormatting.YELLOW), false);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.playerRes", (Object[])new Object[]{resPrefix + res + "% (" + resKoeff + ")"}).withStyle(ChatFormatting.YELLOW), false);
    }

    public static void printDosimeterData(Player player) {
        double env = (double)((int)((double)HbmLivingAttachments.getRadBuf((LivingEntity)player) * 10.0)) / 10.0;
        boolean limit = false;
        if (env > (double)3.6f) {
            env = 3.6f;
            limit = true;
        }
        String envPrefix = ContaminationUtil.getPrefixFromRad(env);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.title.dosimeter").withStyle(ChatFormatting.GOLD), false);
        player.displayClientMessage((Component)Component.translatable((String)"geiger.envRad", (Object[])new Object[]{envPrefix + (limit ? ">" : "") + env + " RAD/s"}).withStyle(ChatFormatting.YELLOW), false);
    }

    public static void printDiagnosticData(Player player) {
        double digamma = (double)((int)(HbmLivingAttachments.getDigamma((LivingEntity)player) * 100.0f)) / 100.0;
        double halfLife = (double)((int)((1.0 - Math.pow(0.5, digamma)) * 10000.0)) / 100.0;
        player.displayClientMessage((Component)Component.translatable((String)"digamma.title").withStyle(ChatFormatting.DARK_PURPLE), false);
        player.displayClientMessage((Component)Component.translatable((String)"digamma.playerDigamma", (Object[])new Object[]{String.valueOf(ChatFormatting.RED) + digamma + " DRX"}).withStyle(ChatFormatting.LIGHT_PURPLE), false);
        player.displayClientMessage((Component)Component.translatable((String)"digamma.playerHealth", (Object[])new Object[]{String.valueOf(ChatFormatting.RED) + halfLife + " %"}).withStyle(ChatFormatting.LIGHT_PURPLE), false);
        player.displayClientMessage((Component)Component.translatable((String)"digamma.playerRes", (Object[])new Object[]{String.valueOf(ChatFormatting.BLUE) + "N/A"}).withStyle(ChatFormatting.LIGHT_PURPLE), false);
    }

    public static String getPrefixFromRad(double rads) {
        if (rads == 0.0) {
            return ChatFormatting.GREEN.toString();
        }
        if (rads < 1.0) {
            return ChatFormatting.YELLOW.toString();
        }
        if (rads < 10.0) {
            return ChatFormatting.GOLD.toString();
        }
        if (rads < 100.0) {
            return ChatFormatting.RED.toString();
        }
        if (rads < 1000.0) {
            return ChatFormatting.DARK_RED.toString();
        }
        return ChatFormatting.DARK_GRAY.toString();
    }

    public static String getPrefixFromRadPlayer(double rads) {
        if (rads < 200.0) {
            return ChatFormatting.GREEN.toString();
        }
        if (rads < 400.0) {
            return ChatFormatting.YELLOW.toString();
        }
        if (rads < 600.0) {
            return ChatFormatting.GOLD.toString();
        }
        if (rads < 800.0) {
            return ChatFormatting.RED.toString();
        }
        if (rads < 1000.0) {
            return ChatFormatting.DARK_RED.toString();
        }
        return ChatFormatting.DARK_GRAY.toString();
    }

    public static String getPrefixFromRadResistance(double koeff) {
        if (koeff > 0.0) {
            return ChatFormatting.GREEN.toString();
        }
        return ChatFormatting.WHITE.toString();
    }

    public static void contaminate(LivingEntity entity, HazardType hazard, ContaminationType type, float amount) {
        if (hazard == HazardType.RADIATION) {
            HbmLivingAttachments.setRadEnv(entity, HbmLivingAttachments.getRadEnv(entity) + amount);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.isCreative() || player.isSpectator() && type != ContaminationType.NONE && type != ContaminationType.DIGAMMA_ROBE) {
                return;
            }
            if (player.tickCount < 200) {
                return;
            }
        }
        if (hazard == HazardType.RADIATION && ContaminationUtil.isRadImmune((Entity)entity)) {
            return;
        }
        switch (hazard.ordinal()) {
            case 0: {
                HbmLivingAttachments.incrementRadiation(entity, amount * (type == ContaminationType.RAD_BYPASS ? 1.0f : ContaminationUtil.calculateRadiationMod(entity)));
                break;
            }
            case 1: {
                HbmLivingAttachments.incrementDigamma(entity, amount);
            }
        }
    }

    public static enum HazardType {
        RADIATION,
        DIGAMMA;

    }

    public static enum ContaminationType {
        FARADAY,
        HAZMAT,
        HAZMAT_HEAVY,
        DIGAMMA,
        DIGAMMA_ROBE,
        CREATIVE,
        RAD_BYPASS,
        NONE;

    }
}

