/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.entity.IResistanceProvider;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.CommonEvents;
import com.hbm.HBMsNTM;
import com.hbm.util.EntityDamageUtil;
import com.hbm.util.Tuple;
import com.hbm.util.i18n.I18nUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber(modid="hbmsntm")
public class DamageResistanceHandler {
    public static float currentPDT = 0.0f;
    public static float currentPDR = 0.0f;
    public static final String CATEGORY_EXPLOSION = "EXPLOSION";
    public static final String CATEGORY_FIRE = "IN_FIRE";
    public static final String CATEGORY_PHYSICAL = "PHYSICAL";
    public static final String CATEGORY_ENERGY = "ENERGY";
    public static final Gson gson = new Gson();
    public static HashMap<Item, ResistanceStats> itemStats = new HashMap();
    public static HashMap<Tuple.Quartet<Item, Item, Item, Item>, ResistanceStats> setStats = new HashMap();
    public static HashMap<Class<? extends Entity>, ResistanceStats> entityStats = new HashMap();
    public static HashMap<Item, List<Tuple.Quartet<Item, Item, Item, Item>>> itemInfoSet = new HashMap();

    public static void init() {
        File folder = CommonEvents.configHbmDir;
        File config = new File(folder.getAbsolutePath() + File.separatorChar + "hbmArmor.json");
        File template = new File(folder.getAbsolutePath() + File.separatorChar + "_hbmArmor.json");
        DamageResistanceHandler.clearSystem();
        if (!config.exists()) {
            DamageResistanceHandler.initDefaults();
            DamageResistanceHandler.writeDefault(template);
        } else {
            DamageResistanceHandler.readConfig(config);
        }
    }

    private static void clearSystem() {
        itemStats.clear();
        setStats.clear();
        entityStats.clear();
        itemInfoSet.clear();
    }

    private static void writeDefault(File file) {
        HBMsNTM.LOGGER.info("No armor file found, registering defaults for {}", (Object)file.getName());
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("comment").value("Template file, remove the underscore ('_') from the name to enable the config.");
            DamageResistanceHandler.serialize(writer);
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void readConfig(File file) {
        HBMsNTM.LOGGER.info("Reading armor file {}", (Object)file.getName());
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(file), JsonObject.class);
            DamageResistanceHandler.deserialize(json);
        }
        catch (FileNotFoundException ex) {
            DamageResistanceHandler.clearSystem();
            DamageResistanceHandler.initDefaults();
            ex.printStackTrace();
        }
    }

    public static void initDefaults() {
        entityStats.put(Creeper.class, new ResistanceStats().addCategory(CATEGORY_EXPLOSION, 2.0f, 0.25f));
        DamageResistanceHandler.registerSet(Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 2.0f, 0.15f).addCategory(CATEGORY_FIRE, 0.0f, 0.25f).addCategory(CATEGORY_EXPLOSION, 0.0f, 0.25f).addExact(DamageTypes.FALL.location().toString(), 4.0f, 0.5f).setOther(2.0f, 0.1f));
        DamageResistanceHandler.registerSet(Items.NETHERITE_HELMET, Items.NETHERITE_CHESTPLATE, Items.NETHERITE_LEGGINGS, Items.NETHERITE_BOOTS, new ResistanceStats().addCategory(CATEGORY_PHYSICAL, 5.0f, 0.5f).addCategory(CATEGORY_FIRE, 5.0f, 0.5f).addCategory(CATEGORY_EXPLOSION, 5.0f, 0.25f).addExact(DamageClass.LASER.name(), 15.0f, 0.9f).addExact(DamageTypes.FALL.location().toString(), 10.0f, 0.5f).setOther(5.0f, 0.25f));
    }

    public static void registerSet(Item helmet, Item plate, Item legs, Item boots, ResistanceStats stats) {
        Tuple.Quartet<Item, Item, Item, Item> set = new Tuple.Quartet<Item, Item, Item, Item>(helmet, plate, legs, boots);
        setStats.put(set, stats);
        if (helmet != null) {
            DamageResistanceHandler.addToListInHashMap(helmet, itemInfoSet, set);
        }
        if (plate != null) {
            DamageResistanceHandler.addToListInHashMap(plate, itemInfoSet, set);
        }
        if (legs != null) {
            DamageResistanceHandler.addToListInHashMap(legs, itemInfoSet, set);
        }
        if (boots != null) {
            DamageResistanceHandler.addToListInHashMap(boots, itemInfoSet, set);
        }
    }

    public static void addToListInHashMap(Item item, HashMap<Item, List<Tuple.Quartet<Item, Item, Item, Item>>> map, Tuple.Quartet<Item, Item, Item, Item> listElement) {
        List list = map.computeIfAbsent(item, k -> new ArrayList());
        list.add(listElement);
    }

    public static void addInfo(ItemStack stack, List<Component> components) {
        Resistance res;
        Item item = stack.getItem();
        if (itemInfoSet.containsKey(item)) {
            List<Tuple.Quartet<Item, Item, Item, Item>> sets = itemInfoSet.get(item);
            for (Tuple.Quartet<Item, Item, Item, Item> quartet : sets) {
                ResistanceStats stats = setStats.get(quartet);
                if (stats == null) continue;
                ArrayList<MutableComponent> toAdd = new ArrayList<MutableComponent>();
                for (Map.Entry<String, Resistance> entry : stats.categoryResistances.entrySet()) {
                    Resistance res2 = entry.getValue();
                    toAdd.add(Component.translatable((String)("damage.category." + entry.getKey()), (Object[])new Object[]{Float.valueOf(res2.threshold), (int)(res2.resistance * 100.0f)}).withStyle(ChatFormatting.GRAY));
                }
                for (Map.Entry<String, Resistance> entry : stats.exactResistances.entrySet()) {
                    Resistance res2 = entry.getValue();
                    toAdd.add(Component.translatable((String)("damage.exact." + entry.getKey()), (Object[])new Object[]{Float.valueOf(res2.threshold), (int)(res2.resistance * 100.0f)}).withStyle(ChatFormatting.GRAY));
                }
                if (stats.otherResistance != null) {
                    res = stats.otherResistance;
                    toAdd.add(Component.translatable((String)"damage.other", (Object[])new Object[]{Float.valueOf(res.threshold), (int)(res.resistance * 100.0f)}).withStyle(ChatFormatting.GRAY));
                }
                if (toAdd.isEmpty()) break;
                components.add((Component)Component.literal((String)I18nUtil.resolveKey("damage.inset", new Object[0])).withStyle(ChatFormatting.DARK_PURPLE));
                if (quartet.getW() != null) {
                    components.add((Component)Component.literal((String)"  ").append(new ItemStack((ItemLike)quartet.getW()).getHoverName()).withStyle(ChatFormatting.DARK_PURPLE));
                }
                if (quartet.getX() != null) {
                    components.add((Component)Component.literal((String)"  ").append(new ItemStack((ItemLike)quartet.getX()).getHoverName()).withStyle(ChatFormatting.DARK_PURPLE));
                }
                if (quartet.getY() != null) {
                    components.add((Component)Component.literal((String)"  ").append(new ItemStack((ItemLike)quartet.getY()).getHoverName()).withStyle(ChatFormatting.DARK_PURPLE));
                }
                if (quartet.getZ() != null) {
                    components.add((Component)Component.literal((String)"  ").append(new ItemStack((ItemLike)quartet.getZ()).getHoverName()).withStyle(ChatFormatting.DARK_PURPLE));
                }
                components.addAll(toAdd);
                break;
            }
        }
        if (itemStats.containsKey(item)) {
            String key;
            ResistanceStats stats = itemStats.get(item);
            ArrayList<MutableComponent> toAdd = new ArrayList<MutableComponent>();
            for (Map.Entry<String, Resistance> entry : stats.categoryResistances.entrySet()) {
                key = "damage.category." + entry.getKey();
                res = entry.getValue();
                toAdd.add(Component.literal((String)(I18nUtil.resolveKey(key, new Object[0]) + ": " + res.threshold + "/" + (int)(res.resistance * 100.0f) + "%")).withStyle(ChatFormatting.GRAY));
            }
            for (Map.Entry<String, Resistance> entry : stats.exactResistances.entrySet()) {
                key = "damage.exact." + entry.getKey();
                res = entry.getValue();
                toAdd.add(Component.literal((String)(I18nUtil.resolveKey(key, new Object[0]) + ": " + res.threshold + "/" + (int)(res.resistance * 100.0f) + "%")).withStyle(ChatFormatting.GRAY));
            }
            if (stats.otherResistance != null) {
                Resistance resistance = stats.otherResistance;
                toAdd.add(Component.literal((String)(I18nUtil.resolveKey("damage.other", new Object[0]) + ": " + resistance.threshold + "/" + (int)(resistance.resistance * 100.0f) + "%")).withStyle(ChatFormatting.GRAY));
            }
            if (!toAdd.isEmpty()) {
                components.add((Component)Component.literal((String)I18nUtil.resolveKey("damage.item", new Object[0])).withStyle(ChatFormatting.DARK_PURPLE));
                components.addAll(toAdd);
            }
        }
    }

    public static void serialize(JsonWriter writer) throws IOException {
        writer.name("itemStats").beginArray();
        for (Map.Entry<Item, ResistanceStats> entry : itemStats.entrySet()) {
            writer.beginArray().setIndent("");
            writer.value(BuiltInRegistries.ITEM.getKey((Object)entry.getKey()).toString()).setIndent("  ");
            writer.beginObject();
            entry.getValue().serialize(writer);
            writer.setIndent("");
            writer.endObject().endArray().setIndent("  ");
        }
        writer.endArray();
        writer.name("setStats").beginArray();
        for (Map.Entry<Object, ResistanceStats> entry : setStats.entrySet()) {
            writer.beginArray().setIndent("");
            writer.value(BuiltInRegistries.ITEM.getKey((Object)((Item)((Tuple.Quartet)entry.getKey()).getW())).toString()).value(BuiltInRegistries.ITEM.getKey((Object)((Item)((Tuple.Quartet)entry.getKey()).getX())).toString()).value(BuiltInRegistries.ITEM.getKey((Object)((Item)((Tuple.Quartet)entry.getKey()).getY())).toString()).value(BuiltInRegistries.ITEM.getKey((Object)((Item)((Tuple.Quartet)entry.getKey()).getZ())).toString()).setIndent("  ");
            writer.beginObject();
            entry.getValue().serialize(writer);
            writer.setIndent("");
            writer.endObject().endArray().setIndent("  ");
        }
        writer.endArray();
        writer.name("entityStats").beginArray();
        for (Map.Entry<Object, ResistanceStats> entry : entityStats.entrySet()) {
            writer.beginArray().setIndent("");
            writer.value(((Class)entry.getKey()).getName()).setIndent("  ");
            writer.beginObject();
            entry.getValue().serialize(writer);
            writer.setIndent("");
            writer.endObject().endArray().setIndent("  ");
        }
        writer.endArray();
    }

    public static void deserialize(JsonObject json) {
        JsonArray itemStatsArray = json.get("itemStats").getAsJsonArray();
        for (Object element : itemStatsArray) {
            JsonArray statArray = element.getAsJsonArray();
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)statArray.get(0).getAsString()));
            JsonObject stats = statArray.get(1).getAsJsonObject();
            itemStats.put(item, ResistanceStats.deserialize(stats));
        }
        JsonArray setStatsArray = json.get("setStats").getAsJsonArray();
        for (JsonElement element : setStatsArray) {
            JsonArray statArray = element.getAsJsonArray();
            Item helmet = statArray.get(0).isJsonNull() ? null : (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)statArray.get(0).getAsString()));
            Item plate = statArray.get(1).isJsonNull() ? null : (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)statArray.get(1).getAsString()));
            Item legs = statArray.get(2).isJsonNull() ? null : (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)statArray.get(2).getAsString()));
            Item boots = statArray.get(3).isJsonNull() ? null : (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)statArray.get(3).getAsString()));
            JsonObject stats = statArray.get(4).getAsJsonObject();
            DamageResistanceHandler.registerSet(helmet, plate, legs, boots, ResistanceStats.deserialize(stats));
        }
        JsonArray entityStatsArray = json.get("entityStats").getAsJsonArray();
        for (JsonElement element : entityStatsArray) {
            JsonArray statArray = element.getAsJsonArray();
            try {
                Class<?> clazz = Class.forName(statArray.get(0).getAsString());
                JsonObject stats = statArray.get(1).getAsJsonObject();
                entityStats.put(clazz, ResistanceStats.deserialize(stats));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    public static void setup(float dt, float dr) {
        currentPDT = dt;
        currentPDR = dr;
    }

    public static void reset() {
        currentPDT = 0.0f;
        currentPDR = 0.0f;
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingIncomingDamageEvent event) {
        DamageSource source = event.getSource();
        if (source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        float amount = event.getOriginalAmount();
        float[] vals = DamageResistanceHandler.getDTDR(entity, source, amount, currentPDT, currentPDR);
        float dt = vals[0] - currentPDT;
        float dr = vals[1] - currentPDR;
        if (dt > 0.0f && dt >= amount || dr >= 1.0f) {
            event.setCanceled(true);
            EntityDamageUtil.damageArmorNT(entity, amount);
        }
    }

    @SubscribeEvent
    public static void onEntityDamaged(LivingDamageEvent.Pre event) {
        event.setNewDamage(DamageResistanceHandler.calculateDamage(event.getEntity(), event.getSource(), event.getOriginalDamage(), currentPDT, currentPDR));
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof IResistanceProvider) {
            IResistanceProvider irp = (IResistanceProvider)livingEntity;
            irp.onDamageDealt(event.getSource(), event.getNewDamage());
        }
    }

    public static String typeToCategory(DamageSource source) {
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            return CATEGORY_EXPLOSION;
        }
        if (source.is(DamageTypeTags.IS_FIRE)) {
            return CATEGORY_FIRE;
        }
        if (source.is(DamageTypeTags.IS_PROJECTILE)) {
            return CATEGORY_PHYSICAL;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return CATEGORY_PHYSICAL;
        }
        if (source.getEntity() != null) {
            return CATEGORY_PHYSICAL;
        }
        String typeId = source.getMsgId();
        if (typeId.equals(DamageClass.LASER.name().toLowerCase())) {
            return CATEGORY_ENERGY;
        }
        if (typeId.equals(DamageClass.MICROWAVE.name().toLowerCase())) {
            return CATEGORY_ENERGY;
        }
        if (typeId.equals(DamageClass.SUBATOMIC.name().toLowerCase())) {
            return CATEGORY_ENERGY;
        }
        return typeId;
    }

    public static float calculateDamage(LivingEntity entity, DamageSource damage, float amount, float pierceDT, float pierce) {
        float[] vals = DamageResistanceHandler.getDTDR(entity, damage, amount, pierceDT, pierce);
        float dt = vals[0];
        float dr = vals[1];
        if ((dt = Math.max(0.0f, dt - pierceDT)) >= amount) {
            return 0.0f;
        }
        amount -= dt;
        return amount *= 1.0f - (dr *= Mth.clamp((float)(1.0f - pierce), (float)0.0f, (float)2.0f));
    }

    public static float[] getDTDR(LivingEntity entity, DamageSource damage, float amount, float pierceDT, float pierce) {
        Resistance res;
        Resistance resistance;
        Tuple.Quartet<Item, Item, Item, Object> wornSet;
        ResistanceStats setResistance;
        float dt = 0.0f;
        float dr = 0.0f;
        if (entity instanceof IResistanceProvider) {
            IResistanceProvider irp = (IResistanceProvider)entity;
            float[] res3 = irp.getCurrentDTDR(damage, amount, pierceDT, pierce);
            dt += res3[0];
            dr += res3[1];
        }
        if ((setResistance = setStats.get(wornSet = new Tuple.Quartet<Item, Item, Item, Object>(entity.getItemBySlot(EquipmentSlot.HEAD).isEmpty() ? null : entity.getItemBySlot(EquipmentSlot.HEAD).getItem(), entity.getItemBySlot(EquipmentSlot.CHEST).isEmpty() ? null : entity.getItemBySlot(EquipmentSlot.CHEST).getItem(), entity.getItemBySlot(EquipmentSlot.LEGS).isEmpty() ? null : entity.getItemBySlot(EquipmentSlot.LEGS).getItem(), (entity.getItemBySlot(EquipmentSlot.FEET).isEmpty() ? null : entity.getItemBySlot(EquipmentSlot.FEET).getItem())))) != null && (resistance = setResistance.getResistance(damage, entity)) != null) {
            dt += resistance.threshold;
            dr += resistance.resistance;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Resistance res4;
            ResistanceStats stats;
            ItemStack armor;
            if (!slot.isArmor() || (armor = entity.getItemBySlot(slot)).isEmpty() || (stats = itemStats.get(armor.getItem())) == null || (res4 = stats.getResistance(damage, entity)) == null) continue;
            dt += res4.threshold;
            dr += res4.resistance;
        }
        ResistanceStats resistanceStats = entityStats.get(entity.getClass());
        if (resistanceStats != null && (res = resistanceStats.getResistance(damage, entity)) != null) {
            dt += res.threshold;
            dr += res.resistance;
        }
        return new float[]{dt, dr};
    }

    public static class ResistanceStats {
        public HashMap<String, Resistance> exactResistances = new HashMap();
        public HashMap<String, Resistance> categoryResistances = new HashMap();
        public Resistance otherResistance;

        public Resistance getResistance(DamageSource source, LivingEntity entity) {
            Registry registry = entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
            String damageTypeId = String.valueOf(registry.getKey((Object)source.type()));
            Resistance exact = this.exactResistances.get(damageTypeId);
            if (exact != null) {
                return exact;
            }
            Resistance category = this.categoryResistances.get(DamageResistanceHandler.typeToCategory(source));
            if (category != null) {
                return category;
            }
            return this.otherResistance;
        }

        public ResistanceStats addExact(String damageTypeId, float threshold, float resistance) {
            this.exactResistances.put(damageTypeId, new Resistance(threshold, resistance));
            return this;
        }

        public ResistanceStats addCategory(String type, float threshold, float resistance) {
            this.categoryResistances.put(type, new Resistance(threshold, resistance));
            return this;
        }

        public ResistanceStats setOther(float threshold, float resistance) {
            this.otherResistance = new Resistance(threshold, resistance);
            return this;
        }

        public void serialize(JsonWriter writer) throws IOException {
            if (!this.exactResistances.isEmpty()) {
                writer.name("exact").beginArray();
                for (Map.Entry<String, Resistance> entry : this.exactResistances.entrySet()) {
                    writer.beginArray().setIndent("");
                    writer.value(entry.getKey()).value(entry.getValue().threshold).value(entry.getValue().resistance).endArray().setIndent("  ");
                }
                writer.endArray();
            }
            if (!this.categoryResistances.isEmpty()) {
                writer.name("category").beginArray();
                for (Map.Entry<String, Resistance> entry : this.categoryResistances.entrySet()) {
                    writer.beginArray().setIndent("");
                    writer.value(entry.getKey()).value(entry.getValue().threshold).value(entry.getValue().resistance).endArray().setIndent("  ");
                }
                writer.endArray();
            }
            if (this.otherResistance != null) {
                writer.name("other").beginArray().setIndent("");
                writer.value(this.otherResistance.threshold).value(this.otherResistance.resistance).endArray().setIndent("  ");
            }
        }

        public static ResistanceStats deserialize(JsonObject json) {
            JsonArray array;
            ResistanceStats stats = new ResistanceStats();
            if (json.has("exact")) {
                JsonArray exact = json.get("exact").getAsJsonArray();
                for (JsonElement element : exact) {
                    array = element.getAsJsonArray();
                    stats.exactResistances.put(array.get(0).getAsString(), new Resistance(array.get(1).getAsFloat(), array.get(2).getAsFloat()));
                }
            }
            if (json.has("category")) {
                JsonArray category = json.get("category").getAsJsonArray();
                for (JsonElement element : category) {
                    array = element.getAsJsonArray();
                    stats.categoryResistances.put(array.get(0).getAsString(), new Resistance(array.get(1).getAsFloat(), array.get(2).getAsFloat()));
                }
            }
            if (json.has("other")) {
                JsonArray other = json.get("other").getAsJsonArray();
                stats.otherResistance = new Resistance(other.get(0).getAsFloat(), other.get(1).getAsFloat());
            }
            return stats;
        }
    }

    public static enum DamageClass {
        PHYSICAL,
        IN_FIRE,
        EXPLOSION,
        ELECTRIC,
        LASER,
        MICROWAVE,
        SUBATOMIC,
        OTHER;

    }

    public static class Resistance {
        public float threshold;
        public float resistance;

        public Resistance(float threshold, float resistance) {
            this.threshold = threshold;
            this.resistance = resistance;
        }
    }
}

