/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.util.TagsUtilDegradation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemStackUtil {
    public static ItemStack carefulCopy(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return stack.copy();
    }

    public static ItemStack carefulCopyWithSize(ItemStack stack, int size) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = stack.copy();
        copy.setCount(size);
        return copy;
    }

    public static ItemStack[] carefulCopyArray(ItemStack[] array) {
        return ItemStackUtil.carefulCopyArray(array, 0, array.length - 1);
    }

    public static ItemStack[] carefulCopyArray(ItemStack[] array, int start, int end) {
        if (array == null) {
            return null;
        }
        ItemStack[] copy = new ItemStack[array.length];
        for (int i = start; i <= end; ++i) {
            copy[i] = ItemStackUtil.carefulCopy(array[i]);
        }
        return copy;
    }

    public static ItemStack[] carefulCopyArrayTruncate(ItemStack[] array, int start, int end) {
        if (array == null) {
            return null;
        }
        int length = end - start + 1;
        ItemStack[] copy = new ItemStack[length];
        for (int i = 0; i < length; ++i) {
            copy[i] = ItemStackUtil.carefulCopy(array[start + i]);
        }
        return copy;
    }

    public static ItemStack addTooltipToStack(ItemStack stack, String ... lines) {
        CompoundTag tag = TagsUtilDegradation.getTag(stack);
        CompoundTag display = new CompoundTag();
        ListTag lore = new ListTag();
        for (String line : lines) {
            lore.add((Object)StringTag.valueOf((String)("\u00a7r\u00a77" + line)));
        }
        display.put("Lore", (Tag)lore);
        tag.put("display", (Tag)display);
        return stack;
    }

    public static void addStacksToNBT(RegistryAccess registryAccess, ItemStack stack, ItemStack ... stacks) {
        CompoundTag tag = TagsUtilDegradation.getTag(stack);
        ListTag items = new ListTag();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i].isEmpty()) continue;
            CompoundTag slotNBT = new CompoundTag();
            slotNBT.putByte("slot", (byte)i);
            stacks[i].save((HolderLookup.Provider)registryAccess, (Tag)slotNBT);
            items.add((Object)slotNBT);
        }
        tag.put("items", (Tag)items);
    }

    public static ItemStack[] readStacksFromNBT(ItemStack stack, HolderLookup.Provider provider, int count) {
        if (!TagsUtilDegradation.containsAnyTag(stack)) {
            return null;
        }
        CompoundTag tag = TagsUtilDegradation.getTag(stack);
        if (!tag.contains("items")) {
            return null;
        }
        ListTag list = tag.getList("items", 10);
        if (count == 0) {
            count = list.size();
        }
        ItemStack[] stacks = new ItemStack[count];
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag slotNBT = list.getCompound(i);
            byte slot = slotNBT.getByte("slot");
            ItemStack loadedStack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)slotNBT).orElse(ItemStack.EMPTY);
            if (slot < 0 || slot >= stacks.length || loadedStack.isEmpty()) continue;
            stacks[slot] = loadedStack;
        }
        return stacks;
    }

    public static ItemStack[] readStacksFromNBT(ItemStack stack, HolderLookup.Provider provider) {
        return ItemStackUtil.readStacksFromNBT(stack, provider, 0);
    }

    public static List<String> getTags(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        stack.getTags().forEach(tagKey -> list.add(tagKey.location().toString()));
        return list;
    }

    public static String getModIdFromItemStack(ItemStack stack) {
        return stack.getItem().builtInRegistryHolder().key().location().getNamespace();
    }

    public static void spillItems(Level level, BlockPos pos, Container container, Random rand) {
        for (int slot = 0; slot < container.getContainerSize(); ++slot) {
            ItemStack stack = container.getItem(slot);
            if (stack.isEmpty()) continue;
            float oX = rand.nextFloat() * 0.8f + 0.1f;
            float oY = rand.nextFloat() * 0.8f + 0.1f;
            float oZ = rand.nextFloat() * 0.8f + 0.1f;
            while (!stack.isEmpty()) {
                int count = Math.min(rand.nextInt(21) + 10, stack.getCount());
                ItemStack drop = stack.split(count);
                ItemEntity itemEntity = new ItemEntity(level, (double)((float)pos.getX() + oX), (double)((float)pos.getY() + oY), (double)((float)pos.getZ() + oZ), drop);
                float motion = 0.05f;
                itemEntity.setDeltaMovement(rand.nextGaussian() * (double)motion, rand.nextGaussian() * (double)motion + (double)0.2f, rand.nextGaussian() * (double)motion);
                level.addFreshEntity((Entity)itemEntity);
            }
        }
    }

    public static boolean areStacksCompatible(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }
}

