/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util.i18n;

import com.hbm.util.i18n.ITranslate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class I18nClient
implements ITranslate {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String resolveKey(String s, Object ... args) {
        return I18n.get((String)s, (Object[])args);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String[] resolveKeyArray(String s, Object ... args) {
        return this.resolveKey(s, args).split("\\$");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<String> autoBreakWithParagraphs(Object fontRenderer, String text, int width) {
        String[] paragraphs = text.split("\\$");
        ArrayList<String> lines = new ArrayList<String>();
        for (String paragraph : paragraphs) {
            lines.addAll(this.autoBreak(fontRenderer, paragraph, width));
        }
        return lines;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<String> autoBreak(Object o, String text, int width) {
        Font fontRenderer = (Font)o;
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        lines.add(words[0]);
        int indent = fontRenderer.width(words[0]);
        for (int w = 1; w < words.length; ++w) {
            if ((indent += fontRenderer.width(" " + words[w])) <= width) {
                String last = (String)lines.getLast();
                lines.set(lines.size() - 1, last + " " + words[w]);
                continue;
            }
            lines.add(words[w]);
            indent = fontRenderer.width(words[w]);
        }
        return lines;
    }
}

