/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util.mixins;

import com.hbm.HBMsNTM;
import com.hbm.HBMsNTMClient;
import com.hbm.config.MainConfig;
import com.hbm.extprop.HbmLivingAttachments;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class})
public class RenderNTMSkybox {
    @Unique
    private static final ResourceLocation DIGAMMA_STAR = HBMsNTM.withDefaultNamespaceNT("textures/misc/star_digamma.png");
    @Unique
    private static final ResourceLocation LODESTAR = HBMsNTM.withDefaultNamespaceNT("textures/misc/star_lode.png");
    @Unique
    private static final ResourceLocation BOBMAZON_SATELLITE = HBMsNTM.withDefaultNamespaceNT("textures/misc/bobmazon_sat.png");

    @Inject(method={"renderSky"}, at={@At(value="TAIL")})
    private void renderSky(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        this.hbmsntm$renderBobmazonSat(frustumMatrix);
        this.hbmsntm$renderDigammaStar(frustumMatrix, partialTick);
        this.hbmsntm$renderLodeStar(frustumMatrix);
    }

    @Unique
    private void hbmsntm$renderDigammaStar(Matrix4f modelView, float partialTicks) {
        if (!((Boolean)MainConfig.CLIENT.SKY_RENDERER.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        float brightness = (float)Math.sin((double)level.getTimeOfDay(partialTicks) * Math.PI);
        brightness *= brightness;
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DIGAMMA_STAR);
        PoseStack poseStack = new PoseStack();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YN.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(level.getTimeOfDay(partialTicks) * 360.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(140.0f));
        poseStack.mulPose(Axis.ZN.rotationDegrees(40.0f));
        Matrix4f finalModelView = new Matrix4f((Matrix4fc)modelView);
        finalModelView.mul((Matrix4fc)poseStack.last().pose());
        poseStack.popPose();
        float digamma = HbmLivingAttachments.getDigamma((LivingEntity)mc.player);
        float size = 1.0f * (1.0f + digamma * 0.25f);
        float dist = 100.0f - digamma * 2.5f;
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buf.addVertex(finalModelView, -size, dist, -size).setUv(0.0f, 0.0f);
        buf.addVertex(finalModelView, size, dist, -size).setUv(0.0f, 1.0f);
        buf.addVertex(finalModelView, size, dist, size).setUv(1.0f, 1.0f);
        buf.addVertex(finalModelView, -size, dist, size).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Unique
    private void hbmsntm$renderBobmazonSat(Matrix4f modelView) {
        if (!((Boolean)MainConfig.CLIENT.SKY_RENDERER.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BOBMAZON_SATELLITE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack poseStack = new PoseStack();
        poseStack.pushPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(-40.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)(System.currentTimeMillis() % 360000L) / 1000.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees((float)(System.currentTimeMillis() % 36000L) / 100.0f));
        Matrix4f finalModelView = new Matrix4f((Matrix4fc)modelView);
        finalModelView.mul((Matrix4fc)poseStack.last().pose());
        poseStack.popPose();
        float size = 0.5f;
        float dist = 100.0f;
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buf.addVertex(finalModelView, -size, dist, -size).setUv(0.0f, 0.0f);
        buf.addVertex(finalModelView, size, dist, -size).setUv(0.0f, 1.0f);
        buf.addVertex(finalModelView, size, dist, size).setUv(1.0f, 1.0f);
        buf.addVertex(finalModelView, -size, dist, size).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Unique
    private void hbmsntm$renderLodeStar(Matrix4f modelView) {
        if (!((Boolean)MainConfig.CLIENT.SKY_RENDERER.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        if (!HBMsNTMClient.renderLodeStar) {
            return;
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LODESTAR);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack poseStack = new PoseStack();
        poseStack.pushPose();
        poseStack.mulPose(Axis.XN.rotationDegrees(75.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(10.0f));
        Matrix4f finalModelView = new Matrix4f((Matrix4fc)modelView);
        finalModelView.mul((Matrix4fc)poseStack.last().pose());
        poseStack.popPose();
        float size = 0.5f + level.random.nextFloat() * 0.25f;
        float dist = 100.0f;
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buf.addVertex(finalModelView, -size, dist, -size).setUv(0.0f, 0.0f);
        buf.addVertex(finalModelView, size, dist, -size).setUv(0.0f, 1.0f);
        buf.addVertex(finalModelView, size, dist, size).setUv(1.0f, 1.0f);
        buf.addVertex(finalModelView, -size, dist, size).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

