/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;

public class WorldUtil {
    public static void setBiomeColumn(ServerLevel level, int blockX, int blockZ, Holder<Biome> biome) {
        LevelChunk chunk = level.getChunk(blockX >> 4, blockZ >> 4);
        int localX = (blockX & 0xF) >> 2;
        int localZ = (blockZ & 0xF) >> 2;
        int minQuartY = level.getMinBuildHeight() >> 2;
        int maxQuartY = level.getMaxBuildHeight() >> 2;
        int minSection = level.getMinSection();
        int sectionsCount = chunk.getSectionsCount();
        for (int quartY = minQuartY; quartY < maxQuartY; ++quartY) {
            int sectionIndex = (quartY >> 2) - minSection;
            if (sectionIndex < 0 || sectionIndex >= sectionsCount) continue;
            LevelChunkSection section = chunk.getSection(sectionIndex);
            int localY = quartY & 3;
            ((PalettedContainer)section.getBiomes()).getAndSetUnchecked(localX, localY, localZ, biome);
        }
        chunk.setUnsaved(true);
    }

    public static void flushChunk(ServerLevel level, LevelChunk chunk) {
        level.getChunkSource().chunkMap.resendBiomesForChunks(List.of(chunk));
    }
}

