/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.biome;

import com.hbm.particle.ModParticles;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((ResourceKey)Registries.BIOME, (String)"hbmsntm");
    public static final ResourceKey<Biome> CRATER = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"crater"));
    public static final ResourceKey<Biome> CRATER_INNER = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"crater_inner"));
    public static final ResourceKey<Biome> CRATER_OUTER = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"crater_outer"));

    public static void register(IEventBus eventBus) {
        BIOMES.register(eventBus);
    }

    public static void bootstrap(BootstrapContext<Biome> ctx) {
        HolderGetter placed = ctx.lookup(Registries.PLACED_FEATURE);
        HolderGetter carvers = ctx.lookup(Registries.CONFIGURED_CARVER);
        ctx.register(CRATER, (Object)ModBiomes.makeCraterBiome((HolderGetter<PlacedFeature>)placed, carvers));
        ctx.register(CRATER_INNER, (Object)ModBiomes.makeCraterInnerBiome((HolderGetter<PlacedFeature>)placed, carvers));
        ctx.register(CRATER_OUTER, (Object)ModBiomes.makeCraterOuterBiome((HolderGetter<PlacedFeature>)placed, carvers));
    }

    private static Biome makeCraterBiome(HolderGetter<PlacedFeature> placed, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return ModBiomes.baseBuilder(placed, carvers).specialEffects(ModBiomes.effects(1054236, 0x606060, 6975545, 0x525A52, 0.01f)).build();
    }

    private static Biome makeCraterOuterBiome(HolderGetter<PlacedFeature> placed, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return ModBiomes.baseBuilder(placed, carvers).specialEffects(ModBiomes.effects(1054236, 7300946, 6975545, 7049609, 0.0f)).build();
    }

    private static Biome makeCraterInnerBiome(HolderGetter<PlacedFeature> placed, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        return ModBiomes.baseBuilder(placed, carvers).specialEffects(ModBiomes.effects(1054236, 0x303030, 6975545, 0x424A42, 0.01f)).build();
    }

    private static Biome.BiomeBuilder baseBuilder(HolderGetter<PlacedFeature> placed, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(placed, carvers);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.8f).downfall(0.0f).mobSpawnSettings(spawns.build()).generationSettings(generation.build());
    }

    private static BiomeSpecialEffects effects(int waterColor, int grassColor, int foliageColor, int skyColor, float particleCount) {
        return new BiomeSpecialEffects.Builder().ambientParticle(new AmbientParticleSettings((ParticleOptions)ModParticles.AURA.get(), particleCount)).waterColor(waterColor).waterFogColor(waterColor).grassColorOverride(grassColor).foliageColorOverride(foliageColor).skyColor(skyColor).fogColor(skyColor).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build();
    }
}

