/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni;

import com.mojang.serialization.Dynamic;
import hama.industries.buni.BuniActivity;
import hama.industries.buni.BuniAi;
import hama.industries.buni.BuniAnimations;
import hama.industries.buni.BuniItem;
import hama.industries.buni.BuniRegistry;
import hama.industries.buni.BuniSounds;
import hama.industries.buni.BuniTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Buni
extends PathfinderMob
implements GeoEntity,
InventoryCarrier {
    public static final EntityDataAccessor<OptionalInt> ACTIVITY = SynchedEntityData.defineId(Buni.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    public static final EntityDataAccessor<Boolean> GUZZLING = SynchedEntityData.defineId(Buni.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> VARIANT_ID = SynchedEntityData.defineId(Buni.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final int MIN_TICKS_TO_PLAY_SOUND = 200;
    public int tumblingTicks;
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final SimpleContainer inventory = new SimpleContainer(1);
    protected int hatred;
    protected int ticksSinceLastSound;
    protected boolean evil;
    @Nullable
    protected LivingEntity thrower;
    protected boolean noPickup;
    private static final Variant[] COMMON_BUNS = new Variant[]{Variant.WHITE, Variant.GRAY, Variant.BROWN};
    private static final Variant[] UNCOMMON_BUNS = new Variant[]{Variant.PINK, Variant.RED, Variant.ORANGE, Variant.BLACK};
    private static final Variant[] RARE_BUNS = new Variant[]{Variant.PURPLE, Variant.DIAMOND, Variant.LIME, Variant.BLUE};

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected Buni(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setCanPickUpLoot(this.canPickUpLoot());
        this.entityData.set(GUZZLING, (Object)(!this.getInventory().isEmpty() ? 1 : 0));
        this.ticksSinceLastSound = (int)(this.getRandom().nextFloat() * 200.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ACTIVITY, (Object)OptionalInt.of(BuiltInRegistries.ACTIVITY.getId((Object)Activity.IDLE)));
        builder.define(GUZZLING, (Object)false);
        builder.define(VARIANT_ID, (Object)Variant.getID(Variant.WHITE));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        BuniAnimations.registerControllers(this, controllers);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public InteractionResult interactAt(Player player, Vec3 hitPos, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            this.entityData.set(VARIANT_ID, (Object)Variant.getID(Objects.requireNonNull(Variant.get(dye.getDyeColor()))));
            return InteractionResult.CONSUME;
        }
        if (stack.isEmpty() && !this.isNoPickup()) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            player.setItemInHand(hand, BuniItem.of(this));
            player.getCooldowns().addCooldown((Item)BuniRegistry.BUNI_ITEM.get(), 5);
            this.discard();
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(player, hitPos, hand);
    }

    protected Brain.Provider<Buni> brainProvider() {
        return BuniAi.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> data) {
        return BuniAi.makeBrain((Brain<Buni>)this.brainProvider().makeBrain(data));
    }

    public Brain<Buni> getBrain() {
        return super.getBrain();
    }

    public boolean hasEmissive() {
        return this.variant().emissive();
    }

    public void checkDespawn() {
        super.checkDespawn();
    }

    public boolean hasItem() {
        return (Boolean)this.entityData.get(GUZZLING);
    }

    public Activity activity() {
        return BuiltInRegistries.ACTIVITY.getHolder(((OptionalInt)this.entityData.get(ACTIVITY)).orElse(-1)).map(Holder::value).orElse(Activity.IDLE);
    }

    public boolean isEvil() {
        return this.evil;
    }

    public void aiStep() {
        super.aiStep();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= 10) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
    }

    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        BuniAi.updateActivity(this);
        this.entityData.set(ACTIVITY, (Object)this.getBrain().getActiveNonCoreActivity().map(act -> OptionalInt.of(BuiltInRegistries.ACTIVITY.getId(act))).orElse(OptionalInt.empty()));
        this.hatred = Math.max(0, this.hatred - 1);
        ++this.tumblingTicks;
    }

    public boolean hurt(DamageSource source, float amount) {
        LivingEntity attacker;
        Vec3 pos = source.getSourcePosition();
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || this.isEvil()) {
            return super.hurt(source, amount);
        }
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).getMainHandItem().is(ItemTags.AXES)) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ((EntityType)BuniRegistry.BUNI.get()).spawn(serverLevel, clone -> {
                    clone.load(this.saveWithoutId(new CompoundTag()));
                    clone.setUUID(UUID.randomUUID());
                    ItemStack stack = this.getInventory().getItem(0);
                    int amt = stack.getCount();
                    if (amt / 2 > 0) {
                        this.getInventory().setItem(0, stack.copyWithCount(amt / 2));
                        clone.getInventory().setItem(0, stack.copyWithCount(amt - amt / 2));
                        clone.entityData.set(GUZZLING, (Object)true);
                    } else {
                        clone.getInventory().clearContent();
                        clone.entityData.set(GUZZLING, (Object)false);
                    }
                    Vec3 norm = attacker.position().cross(this.position());
                    this.knockback(0.5, norm.x, norm.z);
                    clone.knockback(0.5, -norm.x, -norm.z);
                }, this.blockPosition(), MobSpawnType.TRIGGERED, true, false);
            }
        } else {
            if (!this.getInventory().isEmpty()) {
                this.getInventory().removeAllItems().forEach(arg_0 -> ((Buni)this).spawnAtLocation(arg_0));
                this.entityData.set(GUZZLING, (Object)false);
            }
            if (pos != null) {
                this.knockback(2.0, pos.x - this.getX(), pos.z - this.getZ());
                this.ticksSinceLastSound = 0;
                this.playSound((SoundEvent)BuniSounds.HIT.get(), 0.8f, this.varyPitch(1.0f, 0.1f));
            }
        }
        entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.annoyedBy(living);
        }
        return false;
    }

    public boolean isNoPickup() {
        return this.noPickup;
    }

    public void setNoPickup(boolean noPickup) {
        this.noPickup = noPickup;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            ++this.ticksSinceLastSound;
            if (this.ticksSinceLastSound > 200 && (double)this.random.nextFloat() < 0.1) {
                this.ticksSinceLastSound = 0;
                this.playSound((SoundEvent)BuniSounds.IDLE.get(), 0.8f, this.varyPitch(1.0f, 0.1f));
            }
            this.getBrain().getMemory(BuniAi.TUMBLING).ifPresent(tumbling -> {
                if (tumbling.booleanValue()) {
                    for (LivingEntity entity2 : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox(), entity -> entity != this.thrower && !(entity instanceof Buni))) {
                        entity2.hurt(this.damageSources().mobProjectile((Entity)this, this.thrower != null && !this.thrower.isRemoved() ? this.thrower : null), 1.0f);
                    }
                }
            });
        }
    }

    public void knockback(double pStrength, double x, double z) {
        if (!this.level().isClientSide) {
            this.tumblingTicks = 0;
            this.getBrain().setMemory(BuniAi.TUMBLING, (Object)true);
            this.getBrain().setActiveActivityIfPossible((Activity)BuniActivity.TUMBLE);
        }
        super.knockback(pStrength, x, z);
        this.setYRot((float)Mth.atan2((double)z, (double)x));
    }

    public void swing(InteractionHand p_21007_) {
        super.swing(p_21007_);
    }

    public boolean doHurtTarget(Entity entity) {
        boolean result = super.doHurtTarget(entity);
        if (result && !this.level().isClientSide) {
            this.playSound((SoundEvent)BuniSounds.ATTACK.get());
        }
        return result;
    }

    public static BuniGroupData makeNaturalGroupData(LevelAccessor levelAccessor) {
        float chance;
        ResourceLocation key = ((Registry)levelAccessor.registryAccess().registry(Registries.DIMENSION_TYPE).get()).getKey((Object)levelAccessor.dimensionType());
        Variant variant = key.equals((Object)BuiltinDimensionTypes.NETHER.location()) ? Variant.NETHER : (key.equals((Object)BuiltinDimensionTypes.END.location()) ? Variant.ENDER : ((double)(chance = levelAccessor.getRandom().nextFloat()) < 0.01 ? RARE_BUNS[Mth.abs((int)levelAccessor.getRandom().nextInt()) % RARE_BUNS.length] : ((double)chance < 0.1 ? UNCOMMON_BUNS[Mth.abs((int)levelAccessor.getRandom().nextInt()) % UNCOMMON_BUNS.length] : COMMON_BUNS[Mth.abs((int)levelAccessor.getRandom().nextInt()) % COMMON_BUNS.length])));
        return new BuniGroupData(variant);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        if (!(groupData instanceof BuniGroupData)) {
            groupData = spawnType == MobSpawnType.NATURAL ? Buni.makeNaturalGroupData((LevelAccessor)levelAccessor) : new BuniGroupData(Variant.WHITE);
        }
        this.setVariant(((BuniGroupData)groupData).variant);
        return super.finalizeSpawn(levelAccessor, difficulty, spawnType, groupData);
    }

    protected void annoyedBy(LivingEntity attacker) {
        if (this.level().isClientSide) {
            return;
        }
        this.hatred += 1000;
        if (this.hatred > 10000) {
            this.hatred = 0;
            this.killThisGuy(attacker);
        }
    }

    public boolean canTargetEntity(@Nullable Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            return this.level() == entity.level() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity) && !this.isAlliedTo(entity) && entity.getType().is(BuniTags.EntityTypes.BUNI_ATTACK) && !livingentity.isInvulnerable() && !livingentity.isDeadOrDying() && this.level().getWorldBorder().isWithinBounds(livingentity.getBoundingBox());
        }
        return false;
    }

    public boolean isRepelled() {
        return this.brain.getMemory(MemoryModuleType.NEAREST_REPELLENT).isPresent();
    }

    void killThisGuy(LivingEntity target) {
        this.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
        this.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).ifPresent(entities -> entities.forEach(e -> {
            if (e instanceof Buni) {
                e.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
            }
        }));
    }

    public void setVariant(Variant v) {
        this.entityData.set(VARIANT_ID, (Object)Variant.getID(v));
    }

    public Variant variant() {
        return Variant.get((Integer)this.entityData.get(VARIANT_ID));
    }

    protected void pickUpItem(ItemEntity item) {
        InventoryCarrier.pickUpItem((Mob)this, (InventoryCarrier)this, (ItemEntity)item);
        if (!this.level().isClientSide) {
            this.entityData.set(GUZZLING, (Object)(!this.getInventory().isEmpty() ? 1 : 0));
            this.playSound((SoundEvent)BuniSounds.GUZZLE.get(), 0.8f, this.varyPitch(1.0f, 0.15f));
            TransientCraftingContainer craftingcontainer = new TransientCraftingContainer(new AbstractContainerMenu(this, null, -1){

                public ItemStack quickMoveStack(Player p_218264_, int p_218265_) {
                    return ItemStack.EMPTY;
                }

                public boolean stillValid(Player p_29888_) {
                    return false;
                }
            }, 1, 1);
            ItemStack stack = item.getItem();
            craftingcontainer.setItem(0, stack);
            CraftingInput craftingInput = craftingcontainer.asCraftInput();
            ItemStack result = this.level().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingInput, this.level()).map(recipe -> ((CraftingRecipe)recipe.value()).assemble((RecipeInput)craftingInput, (HolderLookup.Provider)this.level().registryAccess())).orElse(null);
            if (result != null && result.is(Tags.Items.DYES)) {
                int amount = stack.getCount() * result.getCount() * 2;
                this.getInventory().setItem(0, result.copyWithCount(amount));
                if (amount > stack.getMaxStackSize()) {
                    this.spawnAtLocation(result.copyWithCount(amount - stack.getMaxStackSize()));
                }
            }
        }
    }

    public boolean canPickUpLoot() {
        return !this.isEvil() && this.getBrain().checkMemory(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryStatus.VALUE_ABSENT);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean wantsToPickUp(ItemStack stack) {
        return this.getInventory().canAddItem(stack);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.writeInventoryToTag(tag, (HolderLookup.Provider)this.registryAccess());
        tag.putInt("buni_variant", this.variant().index());
        tag.putBoolean("evil", this.evil);
        tag.putBoolean("no_pickup", this.noPickup);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readInventoryFromTag(tag, (HolderLookup.Provider)this.registryAccess());
        this.entityData.set(GUZZLING, (Object)(!this.getInventory().isEmpty() ? 1 : 0));
        this.setVariant(Variant.get(tag.getInt("buni_variant")));
        this.evil = tag.getBoolean("evil");
        this.noPickup = tag.getBoolean("no_pickup");
    }

    public CustomData createCustomData() {
        CustomData customdata = CustomData.EMPTY.update(arg_0 -> ((Buni)this).saveAsPassenger(arg_0));
        return customdata;
    }

    private float varyPitch(float pitch, float variance) {
        return (this.random.nextFloat() - 0.5f) * variance + pitch;
    }

    public record Variant(String id, @Nullable DyeColor color, boolean emissive) {
        private static final List<Variant> types = new ObjectArrayList();
        public static final Variant WHITE = new Variant("white", DyeColor.WHITE);
        public static final Variant BLACK = new Variant("black", DyeColor.BLACK);
        public static final Variant BLUE = new Variant("blue", DyeColor.BLUE);
        public static final Variant CYAN = new Variant("cyan", DyeColor.CYAN);
        public static final Variant GRAY = new Variant("gray", DyeColor.GRAY);
        public static final Variant GREEN = new Variant("green", DyeColor.GREEN);
        public static final Variant LIGHT_BLUE = new Variant("light_blue", DyeColor.LIGHT_BLUE);
        public static final Variant LIGHT_GRAY = new Variant("light_gray", DyeColor.LIGHT_GRAY);
        public static final Variant LIME = new Variant("lime", DyeColor.LIME);
        public static final Variant MAGENTA = new Variant("magenta", DyeColor.MAGENTA);
        public static final Variant ORANGE = new Variant("orange", DyeColor.ORANGE);
        public static final Variant PINK = new Variant("pink", DyeColor.PINK);
        public static final Variant PURPLE = new Variant("purple", DyeColor.PURPLE);
        public static final Variant RED = new Variant("red", DyeColor.RED);
        public static final Variant YELLOW = new Variant("yellow", DyeColor.YELLOW);
        public static final Variant BROWN = new Variant("brown", DyeColor.BROWN);
        public static final Variant DIAMOND = new Variant("diamond", null, true);
        public static final Variant ENDER = new Variant("ender", null, true);
        public static final Variant NETHER = new Variant("nether", null, true);

        public Variant(String id, DyeColor color, boolean emissive) {
            this.id = id;
            this.color = color;
            this.emissive = emissive;
            types.add(this);
        }

        private Variant(String id, DyeColor color) {
            this(id, color, false);
        }

        public int index() {
            return Variant.getID(this);
        }

        public static Variant get(int id) {
            return types.get(id);
        }

        public static int getID(Variant v) {
            return types.indexOf(v);
        }

        @Nullable
        public static Variant get(DyeColor color) {
            for (Variant v : types) {
                if (v.color == null || !v.color.equals((Object)color)) continue;
                return v;
            }
            return null;
        }
    }

    public record BuniGroupData(Variant variant) implements SpawnGroupData
    {
    }
}

