/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import hama.industries.buni.Buni;
import hama.industries.buni.BuniActivity;
import hama.industries.buni.BuniMod;
import hama.industries.buni.BuniRegistry;
import hama.industries.buni.BuniTags;
import hama.industries.buni.ai.BuniTargetingSensor;
import hama.industries.buni.ai.LoafingBehavior;
import hama.industries.buni.ai.LoafingSensor;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.sensing.TemptingSensor;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.registries.RegisterEvent;

public class BuniAi {
    public static final SensorType<TemptingSensor> BUNI_TEMPTATIONS = new SensorType(() -> new TemptingSensor((Predicate)Ingredient.of(BuniTags.Items.BUNI_TEMPTATIONS)));
    public static final SensorType<LoafingSensor> LOAFING_SENSOR = new SensorType(LoafingSensor::new);
    public static final SensorType<BuniTargetingSensor> EVIL_SENSOR = new SensorType(BuniTargetingSensor::new);
    public static final MemoryModuleType<Integer> TIME_SINCE_ACTIVITY = new MemoryModuleType(Optional.of(Codec.INT));
    public static final MemoryModuleType<Boolean> WANTS_TO_LOAF = new MemoryModuleType(Optional.of(Codec.BOOL));
    public static final MemoryModuleType<Boolean> TUMBLING = new MemoryModuleType(Optional.of(Codec.BOOL));
    public static final ImmutableList<? extends SensorType<? extends Sensor<? super Buni>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_ITEMS, BUNI_TEMPTATIONS, LOAFING_SENSOR, EVIL_SENSOR);
    public static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.DANCING, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, MemoryModuleType.NEAREST_REPELLENT, TIME_SINCE_ACTIVITY, WANTS_TO_LOAF, TUMBLING});
    public static final int ITEM_STEAL_DISTANCE = 32;

    public static Brain<?> makeBrain(Brain<Buni> brain) {
        BuniAi.initCoreActivity(brain);
        BuniAi.initIdleActivity(brain);
        BuniAi.initFightActivity(brain);
        BuniAi.initDanceActivity(brain);
        BuniAi.initLoafActivity(brain);
        BuniAi.initTumbleActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static Brain.Provider<Buni> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static void initCoreActivity(Brain<Buni> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new Swim(0.1f), (Object)new MoveToTargetSink(10000, 15000), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static BehaviorControl<PathfinderMob> avoidRepellent() {
        return SetWalkTargetAwayFrom.pos((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (float)1.0f, (int)16, (boolean)false);
    }

    public static void initIdleActivity(Brain<Buni> brain) {
        brain.addActivityAndRemoveMemoriesWhenStopped(BuniActivity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new FollowTemptation(e -> Float.valueOf(1.0f))), (Object)Pair.of((Object)1, BuniAi.avoidRepellent()), (Object)Pair.of((Object)2, (Object)GoToWantedItem.create(buni -> !buni.isRepelled(), (float)1.5f, (boolean)true, (int)32)), (Object)Pair.of((Object)3, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)4, (Object)new RunOne(List.of(Pair.of((Object)new DoNothing(30, 60), (Object)2), Pair.of((Object)RandomStroll.stroll((float)1.0f, (boolean)false), (Object)4), Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1))))), Set.of(Pair.of(TIME_SINCE_ACTIVITY, (Object)MemoryStatus.REGISTERED)), Set.of(TIME_SINCE_ACTIVITY));
    }

    public static void initTumbleActivity(Brain<Buni> brain) {
        brain.addActivityAndRemoveMemoriesWhenStopped((Activity)BuniActivity.TUMBLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new DoNothing(10, 10)), (Object)Pair.of((Object)1, (Object)EraseMemoryIf.create(e -> {
            boolean landed;
            boolean bl = landed = e.isPassenger() || e.onGround() && e.tumblingTicks > 3;
            if (landed) {
                e.thrower = null;
            }
            return landed;
        }, TUMBLING))), Set.of(Pair.of(TUMBLING, (Object)MemoryStatus.VALUE_PRESENT)), Set.of(TUMBLING));
    }

    public static void initFightActivity(Brain<Buni> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(e -> Float.valueOf(1.0f)), (Object)MeleeAttack.create((int)20), BuniAi.stopAttackingAfterFirstHit()), MemoryModuleType.ATTACK_TARGET);
    }

    public static void initLoafActivity(Brain<Buni> brain) {
        brain.addActivityAndRemoveMemoriesWhenStopped((Activity)BuniActivity.LOAF, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetLookAndInteract.create((EntityType)((EntityType)BuniRegistry.BUNI.get()), (int)20)), (Object)Pair.of((Object)1, (Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)1)), (Object)Pair.of((Object)1, (Object)((Object)new LoafingBehavior(600, 1200)))), Set.of(Pair.of(WANTS_TO_LOAF, (Object)MemoryStatus.VALUE_PRESENT)), Set.of(WANTS_TO_LOAF, TIME_SINCE_ACTIVITY));
    }

    public static void initDanceActivity(Brain<Buni> brain) {
        brain.addActivityWithConditions((Activity)BuniActivity.DANCE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new DoNothing(20, 30))), Set.of(Pair.of((Object)MemoryModuleType.DANCING, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivity(Buni buni) {
        buni.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)((Object)BuniActivity.TUMBLE), (Object)Activity.FIGHT, (Object)((Object)BuniActivity.DANCE), (Object)((Object)BuniActivity.LOAF), (Object)Activity.IDLE));
    }

    private static BehaviorControl<Buni> stopAttackingAfterFirstHit() {
        return BehaviorBuilder.triggerIf(e -> e.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_COOLING_DOWN), (OneShot)new OneShot<Buni>(){

            public boolean trigger(ServerLevel p_259730_, Buni buni, long p_259489_) {
                buni.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
                return false;
            }
        });
    }

    public static void registerSensorsAndMemories(RegisterEvent event) {
        event.register(Registries.SENSOR_TYPE, BuniMod.id("buni_temptations"), () -> BUNI_TEMPTATIONS);
        event.register(Registries.SENSOR_TYPE, BuniMod.id("loafing"), () -> LOAFING_SENSOR);
        event.register(Registries.SENSOR_TYPE, BuniMod.id("evil"), () -> EVIL_SENSOR);
        event.register(Registries.MEMORY_MODULE_TYPE, BuniMod.id("time_since_activity"), () -> TIME_SINCE_ACTIVITY);
        event.register(Registries.MEMORY_MODULE_TYPE, BuniMod.id("wants_to_loaf"), () -> WANTS_TO_LOAF);
        event.register(Registries.MEMORY_MODULE_TYPE, BuniMod.id("tumbling"), () -> TUMBLING);
    }
}

