/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni;

import hama.industries.buni.BuniRegistry;
import hama.industries.buni.BuniTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

public class BuniDatagen {
    public static void generateData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        event.getGenerator().addProvider(event.includeServer(), output -> new BuniItemTagsProvider(output, event.getLookupProvider(), CompletableFuture.completedFuture(TagsProvider.TagLookup.empty()), "buni", event.getExistingFileHelper()));
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new BuniEntityTypeTagsProvider(packOutput, event.getLookupProvider(), "buni", event.getExistingFileHelper()));
        event.getGenerator().addProvider(event.includeClient(), output -> new BuniItemModelsProvider(output, event.getExistingFileHelper()));
    }

    public static class BuniEntityTypeTagsProvider
    extends EntityTypeTagsProvider {
        public BuniEntityTypeTagsProvider(PackOutput p_275204_, CompletableFuture<HolderLookup.Provider> p_275194_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(p_275204_, p_275194_, modId, existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider lookupProvider) {
            List hostiles = BuiltInRegistries.ENTITY_TYPE.stream().filter(type -> type.getCategory() == MobCategory.MONSTER).collect(Collectors.toList());
            hostiles.add(EntityType.PLAYER);
            hostiles.add((EntityType)BuniRegistry.BUNI.get());
            this.tag(BuniTags.EntityTypes.BUNI_ATTACK).add((Object[])((EntityType[])hostiles.toArray(EntityType[]::new)));
        }
    }

    public static class BuniItemModelsProvider
    extends ItemModelProvider {
        public BuniItemModelsProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "buni", existingFileHelper);
        }

        protected void registerModels() {
            this.basicItem((Item)BuniRegistry.BUNI_ITEM.get());
        }
    }

    public static class BuniItemTagsProvider
    extends ItemTagsProvider {
        public BuniItemTagsProvider(PackOutput p_275204_, CompletableFuture<HolderLookup.Provider> p_275194_, CompletableFuture<TagsProvider.TagLookup<Block>> p_275634_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(p_275204_, p_275194_, p_275634_, modId, existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider lookupProvider) {
            this.tag(BuniTags.Items.BUNI_TEMPTATIONS).addTags(new TagKey[]{ItemTags.FLOWERS, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_BEETROOT}).add((Object[])new Item[]{Items.FERN, Items.LARGE_FERN, Items.SHORT_GRASS, Items.TALL_GRASS, Items.SEAGRASS});
        }
    }
}

