/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni;

import hama.industries.buni.Buni;
import hama.industries.buni.BuniRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BuniItem
extends Item {
    public BuniItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public static ItemStack of(Buni buni) {
        ItemStack stack = ((Item)BuniRegistry.BUNI_ITEM.get()).getDefaultInstance();
        CustomData customData = buni.createCustomData();
        stack.set(DataComponents.ENTITY_DATA, (Object)customData);
        if (buni.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)buni.getCustomName());
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            CustomData tag = (CustomData)stack.get(DataComponents.ENTITY_DATA);
            ((EntityType)BuniRegistry.BUNI.get()).spawn((ServerLevel)level, e -> {
                if (stack.has(DataComponents.CUSTOM_NAME)) {
                    e.setCustomName(stack.getHoverName());
                }
                if (tag != null && !tag.isEmpty()) {
                    e.load(tag.copyTag());
                    Vec3 look = player.getLookAngle();
                    e.setPos(player.getEyePosition().add(look));
                    e.knockback(2.0, -look.x, -look.z);
                    e.thrower = player;
                }
            }, player.getOnPos(), MobSpawnType.BUCKET, true, false);
        }
        return InteractionResultHolder.sidedSuccess((Object)ItemStack.EMPTY, (boolean)level.isClientSide);
    }
}

