/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni;

import hama.industries.buni.Buni;
import hama.industries.buni.BuniConfig;
import hama.industries.buni.BuniGameRules;
import hama.industries.buni.BuniMod;
import hama.industries.buni.BuniRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class BuniSpawner {
    public static final boolean DEV = !FMLEnvironment.production;

    public static void tickSpawnBunis(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide || !((GameRules.BooleanValue)event.getEntity().getServer().getGameRules().getRule(BuniGameRules.RULE_NATURAL_BUNI_SPAWNS)).get()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ServerLevel level = player.serverLevel();
        double originDistance = level.getSharedSpawnPos().getCenter().distanceTo(player.position());
        double spawnChance = (Double)BuniConfig.CONFIG.SPAWN_CHANCE.get() / Math.max(1.0, (originDistance - 1000.0) / 100.0);
        if (player.getRandom().nextDouble() > spawnChance) {
            return;
        }
        int spawnCount = level.getEntitiesOfClass(Buni.class, player.getBoundingBox().inflate((double)((Integer)BuniConfig.CONFIG.MAX_SPAWN_RADIUS.get()).intValue())).size();
        if (spawnCount > (Integer)BuniConfig.CONFIG.NATURAL_SPAWN_CAP.get()) {
            return;
        }
        float th = (float)((double)(level.random.nextFloat() * 2.0f) * Math.PI);
        int spawnWidth = (Integer)BuniConfig.CONFIG.MAX_SPAWN_RADIUS.get() - (Integer)BuniConfig.CONFIG.MIN_SPAWN_RADIUS.get();
        int x = (int)(Mth.cos((float)th) * (float)spawnWidth);
        int z = (int)(Mth.sin((float)th) * (float)spawnWidth);
        x = player.getBlockX() + (Integer)BuniConfig.CONFIG.MIN_SPAWN_RADIUS.get() + x;
        z = player.getBlockZ() + (Integer)BuniConfig.CONFIG.MIN_SPAWN_RADIUS.get() + z;
        BlockPos spawnPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z));
        if (SpawnPlacements.isSpawnPositionOk((EntityType)((EntityType)BuniRegistry.BUNI.get()), (LevelReader)level, (BlockPos)spawnPos)) {
            int bunCount = player.getRandom().nextIntBetweenInclusive(1, 2);
            for (int i = 0; i < bunCount; ++i) {
                Buni buni = (Buni)((EntityType)BuniRegistry.BUNI.get()).spawn(level, spawnPos, MobSpawnType.NATURAL);
            }
            BuniSpawner.logIfDev("spawned buni at {}", spawnPos);
        } else {
            BuniSpawner.logIfDev("failed to spawn buni at {}", spawnPos);
        }
        BuniSpawner.logIfDev("total: {}", spawnCount);
    }

    public static void logIfDev(String s, Object ... args) {
        if (DEV) {
            BuniMod.LOGGER.info(s, args);
        }
    }
}

