/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni;

import com.mojang.serialization.Dynamic;
import hama.industries.buni.BuniActivity;
import hama.industries.buni.BuniAi;
import hama.industries.buni.BuniAnimations;
import hama.industries.buni.BuniItem;
import hama.industries.buni.BuniRegistry;
import hama.industries.buni.BuniSounds;
import hama.industries.buni.BuniTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Buni
extends PathfinderMob
implements GeoEntity,
InventoryCarrier {
    public static final EntityDataAccessor<OptionalInt> ACTIVITY = SynchedEntityData.m_135353_(Buni.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    public static final EntityDataAccessor<Boolean> GUZZLING = SynchedEntityData.m_135353_(Buni.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> VARIANT_ID = SynchedEntityData.m_135353_(Buni.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final int MIN_TICKS_TO_PLAY_SOUND = 200;
    public int tumblingTicks;
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final SimpleContainer inventory = new SimpleContainer(1);
    protected int hatred;
    protected int ticksSinceLastSound;
    protected boolean evil;
    @Nullable
    protected LivingEntity thrower;
    protected boolean noPickup;
    private static final Variant[] COMMON_BUNS = new Variant[]{Variant.WHITE, Variant.GRAY, Variant.BROWN};
    private static final Variant[] UNCOMMON_BUNS = new Variant[]{Variant.PINK, Variant.RED, Variant.ORANGE, Variant.BLACK};
    private static final Variant[] RARE_BUNS = new Variant[]{Variant.PURPLE, Variant.DIAMOND, Variant.LIME, Variant.BLUE};

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected Buni(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.m_21553_(this.m_21531_());
        this.f_19804_.m_135381_(GUZZLING, (Object)(!this.m_35311_().m_7983_() ? 1 : 0));
        this.ticksSinceLastSound = (int)(this.m_217043_().m_188501_() * 200.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTIVITY, (Object)OptionalInt.of(BuiltInRegistries.f_256785_.m_7447_((Object)Activity.f_37979_)));
        this.f_19804_.m_135372_(GUZZLING, (Object)false);
        this.f_19804_.m_135372_(VARIANT_ID, (Object)Variant.getID(Variant.WHITE));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        BuniAnimations.registerControllers(this, controllers);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public InteractionResult m_7111_(Player player, Vec3 hitPos, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            this.f_19804_.m_135381_(VARIANT_ID, (Object)Variant.getID(Objects.requireNonNull(Variant.get(dye.m_41089_()))));
            return InteractionResult.CONSUME;
        }
        if (stack.m_41619_() && !this.isNoPickup()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_21008_(hand, BuniItem.of(this));
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, hitPos, hand);
    }

    protected Brain.Provider<Buni> m_5490_() {
        return BuniAi.brainProvider();
    }

    protected Brain<?> m_8075_(Dynamic<?> data) {
        return BuniAi.makeBrain((Brain<Buni>)this.m_5490_().m_22073_(data));
    }

    public Brain<Buni> m_6274_() {
        return super.m_6274_();
    }

    public boolean hasEmissive() {
        return this.variant().emissive();
    }

    public void m_6043_() {
        super.m_6043_();
    }

    public boolean hasItem() {
        return (Boolean)this.f_19804_.m_135370_(GUZZLING);
    }

    public Activity activity() {
        return BuiltInRegistries.f_256785_.m_203300_(((OptionalInt)this.f_19804_.m_135370_(ACTIVITY)).orElse(-1)).map(Holder::get).orElse(Activity.f_37979_);
    }

    public boolean isEvil() {
        return this.evil;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= 10) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
    }

    protected void m_8024_() {
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        BuniAi.updateActivity(this);
        this.f_19804_.m_135381_(ACTIVITY, (Object)this.m_6274_().m_21968_().map(act -> OptionalInt.of(BuiltInRegistries.f_256785_.m_7447_(act))).orElse(OptionalInt.empty()));
        this.hatred = Math.max(0, this.hatred - 1);
        ++this.tumblingTicks;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity attacker;
        Vec3 pos = source.m_7270_();
        if (source.m_269533_(DamageTypeTags.f_268738_) || this.isEvil()) {
            return super.m_6469_(source, amount);
        }
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).m_21205_().m_204117_(ItemTags.f_271207_)) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ((EntityType)BuniRegistry.BUNI.get()).m_262455_(serverLevel, null, clone -> {
                    clone.deserializeNBT(this.serializeNBT());
                    clone.m_20084_(UUID.randomUUID());
                    ItemStack stack = this.m_35311_().m_8020_(0);
                    int amt = stack.m_41613_();
                    if (amt / 2 > 0) {
                        this.m_35311_().m_6836_(0, stack.m_255036_(amt / 2));
                        clone.m_35311_().m_6836_(0, stack.m_255036_(amt - amt / 2));
                        clone.f_19804_.m_135381_(GUZZLING, (Object)true);
                    } else {
                        clone.m_35311_().m_6211_();
                        clone.f_19804_.m_135381_(GUZZLING, (Object)false);
                    }
                    Vec3 norm = attacker.m_20182_().m_82537_(this.m_20182_());
                    this.m_147240_(0.5, norm.f_82479_, norm.f_82481_);
                    clone.m_147240_(0.5, -norm.f_82479_, -norm.f_82481_);
                }, this.m_20183_(), MobSpawnType.TRIGGERED, true, false);
            }
        } else {
            if (!this.m_35311_().m_7983_()) {
                this.m_35311_().m_19195_().forEach(arg_0 -> ((Buni)this).m_19983_(arg_0));
                this.f_19804_.m_135381_(GUZZLING, (Object)false);
            }
            if (pos != null) {
                this.m_147240_(2.0, pos.f_82479_ - this.m_20185_(), pos.f_82481_ - this.m_20189_());
                this.ticksSinceLastSound = 0;
                this.m_5496_((SoundEvent)BuniSounds.HIT.get(), 0.8f, this.varyPitch(1.0f, 0.1f));
            }
        }
        entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.annoyedBy(living);
        }
        return false;
    }

    public boolean isNoPickup() {
        return this.noPickup;
    }

    public void setNoPickup(boolean noPickup) {
        this.noPickup = noPickup;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ++this.ticksSinceLastSound;
            if (this.ticksSinceLastSound > 200 && (double)this.f_19796_.m_188501_() < 0.1) {
                this.ticksSinceLastSound = 0;
                this.m_5496_((SoundEvent)BuniSounds.IDLE.get(), 0.8f, this.varyPitch(1.0f, 0.1f));
            }
            this.m_6274_().m_21952_(BuniAi.TUMBLING).ifPresent(tumbling -> {
                if (tumbling.booleanValue()) {
                    for (LivingEntity entity2 : this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_(), entity -> entity != this.thrower && !(entity instanceof Buni))) {
                        entity2.m_6469_(this.m_269291_().m_269299_((Entity)this, this.thrower != null && !this.thrower.m_213877_() ? this.thrower : null), 1.0f);
                    }
                }
            });
        }
    }

    public void m_147240_(double pStrength, double x, double z) {
        if (!this.m_9236_().f_46443_) {
            this.tumblingTicks = 0;
            this.m_6274_().m_21879_(BuniAi.TUMBLING, (Object)true);
            this.m_6274_().m_21889_((Activity)BuniActivity.TUMBLE);
        }
        super.m_147240_(pStrength, x, z);
        this.m_146922_((float)Mth.m_14136_((double)z, (double)x));
    }

    public void m_6674_(InteractionHand p_21007_) {
        super.m_6674_(p_21007_);
    }

    public boolean m_7327_(Entity entity) {
        boolean result = super.m_7327_(entity);
        if (result && !this.m_9236_().f_46443_) {
            this.m_216990_((SoundEvent)BuniSounds.ATTACK.get());
        }
        return result;
    }

    public static BuniGroupData makeNaturalGroupData(LevelAccessor levelAccessor) {
        float chance;
        ResourceLocation key = ((Registry)levelAccessor.m_9598_().m_6632_(Registries.f_256787_).get()).m_7981_((Object)levelAccessor.m_6042_());
        Variant variant = key.equals((Object)BuiltinDimensionTypes.f_223539_.m_135782_()) ? Variant.NETHER : (key.equals((Object)BuiltinDimensionTypes.f_223540_.m_135782_()) ? Variant.ENDER : ((double)(chance = levelAccessor.m_213780_().m_188501_()) < 0.01 ? RARE_BUNS[Mth.m_14040_((int)levelAccessor.m_213780_().m_188502_()) % RARE_BUNS.length] : ((double)chance < 0.1 ? UNCOMMON_BUNS[Mth.m_14040_((int)levelAccessor.m_213780_().m_188502_()) % UNCOMMON_BUNS.length] : COMMON_BUNS[Mth.m_14040_((int)levelAccessor.m_213780_().m_188502_()) % COMMON_BUNS.length])));
        return new BuniGroupData(variant);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag p_21438_) {
        if (!(groupData instanceof BuniGroupData)) {
            groupData = spawnType == MobSpawnType.NATURAL ? Buni.makeNaturalGroupData((LevelAccessor)levelAccessor) : new BuniGroupData(Variant.WHITE);
        }
        this.setVariant(((BuniGroupData)groupData).variant);
        return super.m_6518_(levelAccessor, difficulty, spawnType, groupData, p_21438_);
    }

    protected void annoyedBy(LivingEntity attacker) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.hatred += 1000;
        if (this.hatred > 10000) {
            this.hatred = 0;
            this.killThisGuy(attacker);
        }
    }

    public boolean canTargetEntity(@Nullable Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            return this.m_9236_() == entity.m_9236_() && EntitySelector.f_20406_.test(entity) && !this.m_7307_(entity) && entity.m_6095_().m_204039_(BuniTags.EntityTypes.BUNI_ATTACK) && !livingentity.m_20147_() && !livingentity.m_21224_() && this.m_9236_().m_6857_().m_61935_(livingentity.m_20191_());
        }
        return false;
    }

    public boolean isRepelled() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_26356_).isPresent();
    }

    void killThisGuy(LivingEntity target) {
        this.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
        this.m_6274_().m_21952_(MemoryModuleType.f_148204_).ifPresent(entities -> entities.forEach(e -> {
            if (e instanceof Buni) {
                e.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
            }
        }));
    }

    public void setVariant(Variant v) {
        this.f_19804_.m_135381_(VARIANT_ID, (Object)Variant.getID(v));
    }

    public Variant variant() {
        return Variant.get((Integer)this.f_19804_.m_135370_(VARIANT_ID));
    }

    protected void m_7581_(ItemEntity item) {
        InventoryCarrier.m_219611_((Mob)this, (InventoryCarrier)this, (ItemEntity)item);
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(GUZZLING, (Object)(!this.m_35311_().m_7983_() ? 1 : 0));
            this.m_5496_((SoundEvent)BuniSounds.GUZZLE.get(), 0.8f, this.varyPitch(1.0f, 0.15f));
            TransientCraftingContainer craftingcontainer = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                public ItemStack m_7648_(Player p_218264_, int p_218265_) {
                    return ItemStack.f_41583_;
                }

                public boolean m_6875_(Player p_29888_) {
                    return false;
                }
            }, 1, 1);
            ItemStack stack = item.m_32055_();
            craftingcontainer.m_6836_(0, stack);
            ItemStack result = this.m_9236_().m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingcontainer, this.m_9236_()).map(arg_0 -> this.lambda$pickUpItem$6((CraftingContainer)craftingcontainer, arg_0)).orElse(null);
            if (result != null && result.m_204117_(Tags.Items.DYES)) {
                int amount = stack.m_41613_() * result.m_41613_() * 2;
                this.m_35311_().m_6836_(0, result.m_255036_(amount));
                if (amount > stack.m_41741_()) {
                    this.m_19983_(result.m_255036_(amount - stack.m_41741_()));
                }
            }
        }
    }

    public boolean m_21531_() {
        return !this.isEvil() && this.m_6274_().m_21876_(MemoryModuleType.f_217781_, MemoryStatus.VALUE_ABSENT);
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public boolean m_7243_(ItemStack stack) {
        return this.m_35311_().m_19183_(stack);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_252802_(tag);
        tag.m_128405_("buni_variant", this.variant().index());
        tag.m_128379_("evil", this.evil);
        tag.m_128379_("no_pickup", this.noPickup);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_253224_(tag);
        this.f_19804_.m_135381_(GUZZLING, (Object)(!this.m_35311_().m_7983_() ? 1 : 0));
        this.setVariant(Variant.get(tag.m_128451_("buni_variant")));
        this.evil = tag.m_128471_("evil");
        this.noPickup = tag.m_128471_("no_pickup");
    }

    private float varyPitch(float pitch, float variance) {
        return (this.f_19796_.m_188501_() - 0.5f) * variance + pitch;
    }

    public double m_6049_() {
        return super.m_6049_() + 0.15;
    }

    private /* synthetic */ ItemStack lambda$pickUpItem$6(CraftingContainer craftingcontainer, CraftingRecipe recipe) {
        return recipe.m_5874_((Container)craftingcontainer, this.m_9236_().m_9598_());
    }

    public record Variant(String id, @Nullable DyeColor color, boolean emissive) {
        private static final List<Variant> types = new ObjectArrayList();
        public static final Variant WHITE = new Variant("white", DyeColor.WHITE);
        public static final Variant BLACK = new Variant("black", DyeColor.BLACK);
        public static final Variant BLUE = new Variant("blue", DyeColor.BLUE);
        public static final Variant CYAN = new Variant("cyan", DyeColor.CYAN);
        public static final Variant GRAY = new Variant("gray", DyeColor.GRAY);
        public static final Variant GREEN = new Variant("green", DyeColor.GREEN);
        public static final Variant LIGHT_BLUE = new Variant("light_blue", DyeColor.LIGHT_BLUE);
        public static final Variant LIGHT_GRAY = new Variant("light_gray", DyeColor.LIGHT_GRAY);
        public static final Variant LIME = new Variant("lime", DyeColor.LIME);
        public static final Variant MAGENTA = new Variant("magenta", DyeColor.MAGENTA);
        public static final Variant ORANGE = new Variant("orange", DyeColor.ORANGE);
        public static final Variant PINK = new Variant("pink", DyeColor.PINK);
        public static final Variant PURPLE = new Variant("purple", DyeColor.PURPLE);
        public static final Variant RED = new Variant("red", DyeColor.RED);
        public static final Variant YELLOW = new Variant("yellow", DyeColor.YELLOW);
        public static final Variant BROWN = new Variant("brown", DyeColor.BROWN);
        public static final Variant DIAMOND = new Variant("diamond", null, true);
        public static final Variant ENDER = new Variant("ender", null, true);
        public static final Variant NETHER = new Variant("nether", null, true);

        public Variant(String id, DyeColor color, boolean emissive) {
            this.id = id;
            this.color = color;
            this.emissive = emissive;
            types.add(this);
        }

        private Variant(String id, DyeColor color) {
            this(id, color, false);
        }

        public int index() {
            return Variant.getID(this);
        }

        public static Variant get(int id) {
            return types.get(id);
        }

        public static int getID(Variant v) {
            return types.indexOf(v);
        }

        @Nullable
        public static Variant get(DyeColor color) {
            for (Variant v : types) {
                if (v.color == null || !v.color.equals((Object)color)) continue;
                return v;
            }
            return null;
        }
    }

    public record BuniGroupData(Variant variant) implements SpawnGroupData
    {
    }
}

