/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import hama.industries.buni.Buni;
import hama.industries.buni.BuniActivity;
import hama.industries.buni.BuniMod;
import hama.industries.buni.BuniRegistry;
import hama.industries.buni.BuniTags;
import hama.industries.buni.ai.BuniTargetingSensor;
import hama.industries.buni.ai.LoafingBehavior;
import hama.industries.buni.ai.LoafingSensor;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.sensing.TemptingSensor;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public class BuniAi {
    public static final SensorType<TemptingSensor> BUNI_TEMPTATIONS = new SensorType(() -> new TemptingSensor(Ingredient.m_204132_(BuniTags.Items.BUNI_TEMPTATIONS)));
    public static final SensorType<LoafingSensor> LOAFING_SENSOR = new SensorType(LoafingSensor::new);
    public static final SensorType<BuniTargetingSensor> EVIL_SENSOR = new SensorType(BuniTargetingSensor::new);
    public static final MemoryModuleType<Integer> TIME_SINCE_ACTIVITY = new MemoryModuleType(Optional.of(Codec.INT));
    public static final MemoryModuleType<Boolean> WANTS_TO_LOAF = new MemoryModuleType(Optional.of(Codec.BOOL));
    public static final MemoryModuleType<Boolean> TUMBLING = new MemoryModuleType(Optional.of(Codec.BOOL));
    public static final ImmutableList<? extends SensorType<? extends Sensor<? super Buni>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26810_, BUNI_TEMPTATIONS, LOAFING_SENSOR, EVIL_SENSOR);
    public static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26374_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_217768_, (Object)MemoryModuleType.f_148197_, (Object)MemoryModuleType.f_148198_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_148205_, MemoryModuleType.f_148204_, MemoryModuleType.f_26342_, MemoryModuleType.f_217781_, MemoryModuleType.f_26332_, MemoryModuleType.f_26356_, TIME_SINCE_ACTIVITY, WANTS_TO_LOAF, TUMBLING});
    public static final int ITEM_STEAL_DISTANCE = 32;

    public static Brain<?> makeBrain(Brain<Buni> brain) {
        BuniAi.initCoreActivity(brain);
        BuniAi.initIdleActivity(brain);
        BuniAi.initFightActivity(brain);
        BuniAi.initDanceActivity(brain);
        BuniAi.initLoafActivity(brain);
        BuniAi.initTumbleActivity(brain);
        brain.m_21930_(Set.of(Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static Brain.Provider<Buni> brainProvider() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static void initCoreActivity(Brain<Buni> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new Swim(0.1f), (Object)new MoveToTargetSink(10000, 15000), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_)));
    }

    private static BehaviorControl<PathfinderMob> avoidRepellent() {
        return SetWalkTargetAwayFrom.m_257620_((MemoryModuleType)MemoryModuleType.f_26356_, (float)1.0f, (int)16, (boolean)false);
    }

    public static void initIdleActivity(Brain<Buni> brain) {
        brain.m_21907_(BuniActivity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new FollowTemptation(e -> Float.valueOf(1.0f))), (Object)Pair.of((Object)1, BuniAi.avoidRepellent()), (Object)Pair.of((Object)2, (Object)GoToWantedItem.m_257684_(buni -> !buni.isRepelled(), (float)1.5f, (boolean)true, (int)32)), (Object)Pair.of((Object)3, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)4, (Object)new RunOne(List.of(Pair.of((Object)new DoNothing(30, 60), (Object)2), Pair.of((Object)RandomStroll.m_257798_((float)1.0f, (boolean)false), (Object)4), Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)1))))), Set.of(Pair.of(TIME_SINCE_ACTIVITY, (Object)MemoryStatus.REGISTERED)), Set.of(TIME_SINCE_ACTIVITY));
    }

    public static void initTumbleActivity(Brain<Buni> brain) {
        brain.m_21907_((Activity)BuniActivity.TUMBLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new DoNothing(10, 10)), (Object)Pair.of((Object)1, (Object)EraseMemoryIf.m_258093_(e -> {
            boolean landed;
            boolean bl = landed = e.m_20159_() || e.m_20096_() && e.tumblingTicks > 3;
            if (landed) {
                e.thrower = null;
            }
            return landed;
        }, TUMBLING))), Set.of(Pair.of(TUMBLING, (Object)MemoryStatus.VALUE_PRESENT)), Set.of(TUMBLING));
    }

    public static void initFightActivity(Brain<Buni> brain) {
        brain.m_21895_(Activity.f_37988_, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.m_257822_(), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257648_(e -> Float.valueOf(1.0f)), (Object)MeleeAttack.m_257733_((int)20), BuniAi.stopAttackingAfterFirstHit()), MemoryModuleType.f_26372_);
    }

    public static void initLoafActivity(Brain<Buni> brain) {
        brain.m_21907_((Activity)BuniActivity.LOAF, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetLookAndInteract.m_257430_((EntityType)((EntityType)BuniRegistry.BUNI.get()), (int)20)), (Object)Pair.of((Object)1, (Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)1)), (Object)Pair.of((Object)1, (Object)((Object)new LoafingBehavior(600, 1200)))), Set.of(Pair.of(WANTS_TO_LOAF, (Object)MemoryStatus.VALUE_PRESENT)), Set.of(WANTS_TO_LOAF, TIME_SINCE_ACTIVITY));
    }

    public static void initDanceActivity(Brain<Buni> brain) {
        brain.m_21903_((Activity)BuniActivity.DANCE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new DoNothing(20, 30))), Set.of(Pair.of((Object)MemoryModuleType.f_26342_, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivity(Buni buni) {
        buni.m_6274_().m_21926_((List)ImmutableList.of((Object)((Object)BuniActivity.TUMBLE), (Object)Activity.f_37988_, (Object)((Object)BuniActivity.DANCE), (Object)((Object)BuniActivity.LOAF), (Object)Activity.f_37979_));
    }

    private static BehaviorControl<Buni> stopAttackingAfterFirstHit() {
        return BehaviorBuilder.m_257845_(e -> e.m_6274_().m_21874_(MemoryModuleType.f_26373_), (OneShot)new OneShot<Buni>(){

            public boolean trigger(ServerLevel p_259730_, Buni buni, long p_259489_) {
                buni.m_6274_().m_21936_(MemoryModuleType.f_26372_);
                return false;
            }
        });
    }

    public static void registerSensorsAndMemories(RegisterEvent event) {
        event.register(ForgeRegistries.SENSOR_TYPES.getRegistryKey(), BuniMod.id("buni_temptations"), () -> BUNI_TEMPTATIONS);
        event.register(ForgeRegistries.SENSOR_TYPES.getRegistryKey(), BuniMod.id("loafing"), () -> LOAFING_SENSOR);
        event.register(ForgeRegistries.SENSOR_TYPES.getRegistryKey(), BuniMod.id("evil"), () -> EVIL_SENSOR);
        event.register(ForgeRegistries.MEMORY_MODULE_TYPES.getRegistryKey(), BuniMod.id("time_since_activity"), () -> TIME_SINCE_ACTIVITY);
        event.register(ForgeRegistries.MEMORY_MODULE_TYPES.getRegistryKey(), BuniMod.id("wants_to_loaf"), () -> WANTS_TO_LOAF);
        event.register(ForgeRegistries.MEMORY_MODULE_TYPES.getRegistryKey(), BuniMod.id("tumbling"), () -> TUMBLING);
    }
}

