/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni;

import hama.industries.buni.BuniRegistry;
import hama.industries.buni.BuniTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

public class BuniDatagen {
    public static void generateData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        event.getGenerator().addProvider(event.includeServer(), output -> new BuniItemTagsProvider(output, event.getLookupProvider(), CompletableFuture.completedFuture(TagsProvider.TagLookup.m_274566_()), "buni", event.getExistingFileHelper()));
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new BuniEntityTypeTagsProvider(packOutput, event.getLookupProvider(), "buni", event.getExistingFileHelper()));
        event.getGenerator().addProvider(event.includeClient(), output -> new BuniItemModelsProvider(output, event.getExistingFileHelper()));
    }

    public static class BuniEntityTypeTagsProvider
    extends EntityTypeTagsProvider {
        public BuniEntityTypeTagsProvider(PackOutput p_275204_, CompletableFuture<HolderLookup.Provider> p_275194_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(p_275204_, p_275194_, modId, existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider lookupProvider) {
            List hostiles = BuiltInRegistries.f_256780_.m_123024_().filter(type -> type.m_20674_() == MobCategory.MONSTER).collect(Collectors.toList());
            hostiles.add(EntityType.f_20532_);
            hostiles.add((EntityType)BuniRegistry.BUNI.get());
            this.m_206424_(BuniTags.EntityTypes.BUNI_ATTACK).m_255179_((Object[])((EntityType[])hostiles.toArray(EntityType[]::new)));
        }
    }

    public static class BuniItemModelsProvider
    extends ItemModelProvider {
        public BuniItemModelsProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "buni", existingFileHelper);
        }

        protected void registerModels() {
            this.basicItem((Item)BuniRegistry.BUNI_ITEM.get());
        }
    }

    public static class BuniItemTagsProvider
    extends ItemTagsProvider {
        public BuniItemTagsProvider(PackOutput p_275204_, CompletableFuture<HolderLookup.Provider> p_275194_, CompletableFuture<TagsProvider.TagLookup<Block>> p_275634_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(p_275204_, p_275194_, p_275634_, modId, existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider lookupProvider) {
            this.m_206424_(BuniTags.Items.BUNI_TEMPTATIONS).addTags(new TagKey[]{ItemTags.f_13149_, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_BEETROOT}).m_255179_((Object[])new Item[]{Items.f_41865_, Items.f_42211_, Items.f_41864_, Items.f_42210_, Items.f_41867_});
        }
    }
}

