/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni;

import hama.industries.buni.Buni;
import hama.industries.buni.BuniConfig;
import hama.industries.buni.BuniGameRules;
import hama.industries.buni.BuniMod;
import hama.industries.buni.BuniRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class BuniSpawner {
    public static final boolean DEV = !FMLEnvironment.production;

    public static void tickSpawnBunis(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT || event.phase == TickEvent.Phase.START || !((GameRules.BooleanValue)event.player.m_20194_().m_129900_().m_46170_(BuniGameRules.RULE_NATURAL_BUNI_SPAWNS)).m_46223_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        ServerLevel level = player.m_284548_();
        double originDistance = level.m_220360_().m_252807_().m_82554_(player.m_20182_());
        double spawnChance = (Double)BuniConfig.CONFIG.SPAWN_CHANCE.get() / Math.max(1.0, (originDistance - 1000.0) / 100.0);
        if (player.m_217043_().m_188500_() > spawnChance) {
            return;
        }
        int spawnCount = level.m_45976_(Buni.class, player.m_20191_().m_82400_((double)((Integer)BuniConfig.CONFIG.MAX_SPAWN_RADIUS.get()).intValue())).size();
        if (spawnCount > (Integer)BuniConfig.CONFIG.NATURAL_SPAWN_CAP.get()) {
            return;
        }
        float th = (float)((double)(level.f_46441_.m_188501_() * 2.0f) * Math.PI);
        int spawnWidth = (Integer)BuniConfig.CONFIG.MAX_SPAWN_RADIUS.get() - (Integer)BuniConfig.CONFIG.MIN_SPAWN_RADIUS.get();
        int x = (int)(Mth.m_14089_((float)th) * (float)spawnWidth);
        int z = (int)(Mth.m_14031_((float)th) * (float)spawnWidth);
        x = player.m_146903_() + (Integer)BuniConfig.CONFIG.MIN_SPAWN_RADIUS.get() + x;
        BlockPos spawnPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z = player.m_146907_() + (Integer)BuniConfig.CONFIG.MIN_SPAWN_RADIUS.get() + z));
        if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)spawnPos, (EntityType)((EntityType)BuniRegistry.BUNI.get()))) {
            int bunCount = player.m_217043_().m_216332_(1, 2);
            for (int i = 0; i < bunCount; ++i) {
                Buni buni = (Buni)((EntityType)BuniRegistry.BUNI.get()).m_262496_(level, spawnPos, MobSpawnType.NATURAL);
            }
            BuniSpawner.logIfDev("spawned buni at {}", spawnPos);
        } else {
            BuniSpawner.logIfDev("failed to spawn buni at {}", spawnPos);
        }
        BuniSpawner.logIfDev("total: {}", spawnCount);
    }

    public static void logIfDev(String s, Object ... args) {
        if (DEV) {
            BuniMod.LOGGER.info(s, args);
        }
    }
}

