/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni.ai;

import hama.industries.buni.Buni;
import hama.industries.buni.BuniActivity;
import hama.industries.buni.BuniConfig;
import hama.industries.buni.BuniSounds;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BuniTargetingSensor
extends Sensor<Buni> {
    protected void doTick(ServerLevel level, Buni buni) {
        Brain<Buni> brain = buni.m_6274_();
        boolean hadRepellent = brain.m_21952_(MemoryModuleType.f_26356_).isPresent();
        brain.m_21886_(MemoryModuleType.f_26356_, BuniTargetingSensor.findNearestRepellent(level, (LivingEntity)buni));
        if (!hadRepellent && buni.isRepelled()) {
            buni.m_216990_((SoundEvent)BuniSounds.REPELLED.get());
        }
        if (!buni.isRepelled() && buni.m_217043_().m_188500_() < (Double)BuniConfig.CONFIG.PICK_ON_CHANCE.get() && brain.m_21968_().filter(act -> act == BuniActivity.DANCE).isEmpty() && brain.m_21952_(MemoryModuleType.f_26372_).isEmpty()) {
            Optional target = brain.m_21952_(MemoryModuleType.f_148205_).flatMap(nearest -> nearest.m_186116_(buni::canTargetEntity));
            brain.m_21886_(MemoryModuleType.f_26372_, target);
        }
    }

    private static Optional<BlockPos> findNearestRepellent(ServerLevel pLevel, LivingEntity pLivingEntity) {
        return BlockPos.m_121930_((BlockPos)pLivingEntity.m_20183_(), (int)16, (int)8, pos -> BuniTargetingSensor.isValidRepellent(pLevel, pos));
    }

    private static boolean isValidRepellent(ServerLevel pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.m_8055_(pPos);
        boolean flag = blockstate.m_204336_(BlockTags.f_13042_);
        return flag && blockstate.m_60713_(Blocks.f_50684_) ? CampfireBlock.m_51319_((BlockState)blockstate) : flag;
    }

    public Set<MemoryModuleType<?>> m_7163_() {
        return Set.of(MemoryModuleType.f_148205_, MemoryModuleType.f_26372_);
    }
}

