/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import hama.industries.buni.Buni;
import hama.industries.buni.BuniMod;
import hama.industries.buni.client.BuniModel;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.FastBoneFilterGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class BuniRenderer
extends GeoEntityRenderer<Buni> {
    public BuniRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new BuniModel());
        this.addRenderLayer((GeoRenderLayer)new OptionalGlowingGeoLayer((GeoRenderer<Buni>)this));
        this.addRenderLayer((GeoRenderLayer)new FastBoneFilterGeoLayer((GeoRenderer)this, () -> List.of("mallet"), this::updateMalletVisibility));
        this.addRenderLayer((GeoRenderLayer)new FastBoneFilterGeoLayer((GeoRenderer)this, () -> List.of("tube"), this::updateTubeVisibility));
        this.addRenderLayer((GeoRenderLayer)new FastBoneFilterGeoLayer((GeoRenderer)this, () -> List.of("glasses"), (bone, buni, ticks) -> bone.setHidden(!buni.m_7755_().getString().equals("yuki"))));
        this.scaleWidth = 0.7f;
        this.scaleHeight = 0.7f;
    }

    public void updateMalletVisibility(GeoBone bone, Buni buni, float partialTicks) {
        bone.setHidden(!buni.f_20911_);
    }

    public void updateTubeVisibility(GeoBone bone, Buni buni, float partialTicks) {
        bone.setHidden(!buni.m_20069_());
    }

    public ResourceLocation getTextureLocation(Buni buni) {
        if (buni.variant().equals(Buni.Variant.WHITE)) {
            return super.m_5478_((Entity)buni);
        }
        return BuniMod.id("textures/entity/buni_" + buni.variant().id() + ".png");
    }

    private static class OptionalGlowingGeoLayer
    extends AutoGlowingGeoLayer<Buni> {
        public OptionalGlowingGeoLayer(GeoRenderer<Buni> renderer) {
            super(renderer);
        }

        public void render(PoseStack poseStack, Buni buni, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        }
    }
}

