/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni;

import hama.industries.buni.Buni;
import hama.industries.buni.BuniRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.VanillaGameEvent;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class BuniEvents {
    public static void init() {
        NeoForge.EVENT_BUS.addListener(BuniEvents::overrideMobGriefing);
        NeoForge.EVENT_BUS.addListener(BuniEvents::updateJukeboxPlayingState);
        NeoForge.EVENT_BUS.addListener(BuniEvents::protecc);
    }

    public static void overrideMobGriefing(EntityMobGriefingEvent event) {
        if (event.getEntity().getType().equals(BuniRegistry.BUNI.get())) {
            event.setCanGrief(true);
        }
    }

    public static void updateJukeboxPlayingState(VanillaGameEvent event) {
        block3: {
            int r;
            block2: {
                r = ((GameEvent)event.getVanillaEvent().value()).notificationRadius();
                if (event.getVanillaEvent() != GameEvent.JUKEBOX_PLAY) break block2;
                for (Buni bun : event.getLevel().getEntitiesOfClass(Buni.class, AABB.ofSize((Vec3)event.getEventPosition(), (double)r, (double)r, (double)r))) {
                    bun.getBrain().setMemoryWithExpiry(MemoryModuleType.DANCING, (Object)true, 100L);
                }
                break block3;
            }
            if (event.getVanillaEvent() != GameEvent.JUKEBOX_STOP_PLAY) break block3;
            for (Buni bun : event.getLevel().getEntitiesOfClass(Buni.class, AABB.ofSize((Vec3)event.getEventPosition(), (double)r, (double)r, (double)r))) {
                bun.getBrain().eraseMemory(MemoryModuleType.DANCING);
            }
        }
    }

    public static void protecc(LivingDamageEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            LivingEntity attacker;
            Player player = (Player)livingEntity;
            if (player.level().isClientSide) {
                return;
            }
            Entity entity = event.getSource().getDirectEntity();
            if (entity instanceof LivingEntity && !((attacker = (LivingEntity)entity) instanceof Buni)) {
                player.level().getEntitiesOfClass(Buni.class, player.getBoundingBox().inflate(20.0)).stream().findAny().ifPresent(b -> b.killThisGuy(attacker));
            }
        }
    }
}

