/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni.ai;

import hama.industries.buni.Buni;
import hama.industries.buni.BuniActivity;
import hama.industries.buni.BuniConfig;
import hama.industries.buni.BuniSounds;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BuniTargetingSensor
extends Sensor<Buni> {
    protected void doTick(ServerLevel level, Buni buni) {
        Brain<Buni> brain = buni.getBrain();
        boolean hadRepellent = brain.getMemory(MemoryModuleType.NEAREST_REPELLENT).isPresent();
        brain.setMemory(MemoryModuleType.NEAREST_REPELLENT, BuniTargetingSensor.findNearestRepellent(level, (LivingEntity)buni));
        if (!hadRepellent && buni.isRepelled()) {
            buni.playSound((SoundEvent)BuniSounds.REPELLED.get());
        }
        if (!buni.isRepelled() && buni.getRandom().nextDouble() < (Double)BuniConfig.CONFIG.PICK_ON_CHANCE.get() && brain.getActiveNonCoreActivity().filter(act -> act == BuniActivity.DANCE).isEmpty() && brain.getMemory(MemoryModuleType.ATTACK_TARGET).isEmpty()) {
            Optional target = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(nearest -> nearest.findClosest(buni::canTargetEntity));
            brain.setMemory(MemoryModuleType.ATTACK_TARGET, target);
        }
    }

    private static Optional<BlockPos> findNearestRepellent(ServerLevel pLevel, LivingEntity pLivingEntity) {
        return BlockPos.findClosestMatch((BlockPos)pLivingEntity.blockPosition(), (int)16, (int)8, pos -> BuniTargetingSensor.isValidRepellent(pLevel, pos));
    }

    private static boolean isValidRepellent(ServerLevel pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        boolean flag = blockstate.is(BlockTags.PIGLIN_REPELLENTS);
        return flag && blockstate.is(Blocks.SOUL_CAMPFIRE) ? CampfireBlock.isLitCampfire((BlockState)blockstate) : flag;
    }

    public Set<MemoryModuleType<?>> requires() {
        return Set.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.ATTACK_TARGET);
    }
}

