/*
 * Decompiled with CFR 0.152.
 */
package hama.industries.buni.ai;

import hama.industries.buni.Buni;
import hama.industries.buni.BuniAi;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.schedule.Activity;

public class LoafingSensor
extends Sensor<Buni> {
    private static final int SECONDS_TO_LOAF = 30;

    protected void doTick(ServerLevel level, Buni buni) {
        Brain<Buni> brain = buni.getBrain();
        Optional currentActivity = brain.getActiveNonCoreActivity();
        if (currentActivity.filter(activity -> activity == Activity.IDLE).isPresent()) {
            int time = brain.getMemory(BuniAi.TIME_SINCE_ACTIVITY).orElse(0) + 1;
            brain.setMemory(BuniAi.TIME_SINCE_ACTIVITY, Optional.of(time));
            if (!buni.isRepelled() && time > 30 && (double)buni.getRandom().nextFloat() < 0.1) {
                brain.setMemory(BuniAi.WANTS_TO_LOAF, (Object)true);
            }
        }
    }

    public Set<MemoryModuleType<?>> requires() {
        return Set.of(BuniAi.TIME_SINCE_ACTIVITY, BuniAi.WANTS_TO_LOAF, MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.NEAREST_LIVING_ENTITIES);
    }
}

