/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block;

import gdavid.phi.block.tile.CableTile;
import gdavid.phi.cable.CableNetwork;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CableBlock
extends Block
implements EntityBlock {
    public static final String id = "cable";
    public static final BooleanProperty online = BooleanProperty.m_61465_((String)"online");
    public static final Map<Direction, EnumProperty<CableSide>> sides = new HashMap<Direction, EnumProperty<CableSide>>();
    static final VoxelShape shape;

    public CableBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60918_(SoundType.f_56736_).m_60910_());
        BlockState state = (BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)online, (Comparable)Boolean.valueOf(false));
        for (EnumProperty<CableSide> side : sides.values()) {
            state = (BlockState)state.m_61124_(side, (Comparable)((Object)CableSide.none));
        }
        this.m_49959_(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.m_237115_((String)"block.phi.cable.desc"));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{online});
        for (EnumProperty<CableSide> side : sides.values()) {
            builder.m_61104_(new Property[]{side});
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return CableBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.f_46443_ && oldState.m_60734_() != this) {
            CableNetwork.rebuild(world, pos);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean flag) {
        super.m_6810_(state, world, pos, newState, flag);
        if (!world.f_46443_ && newState.m_60734_() != this) {
            CableNetwork.rebuild(world, pos);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CableTile(pos, state);
    }

    static {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            sides.put(dir, (EnumProperty<CableSide>)EnumProperty.m_61587_((String)dir.m_7912_(), CableSide.class));
        }
        shape = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    }

    public static enum CableSide implements StringRepresentable
    {
        none,
        side,
        up;


        public String m_7912_() {
            return this.name();
        }
    }
}

