/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block;

import gdavid.phi.block.tile.MPUTile;
import gdavid.phi.cable.CableNetwork;
import gdavid.phi.util.RedstoneMode;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;

public class MPUBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final String id = "mpu";

    public MPUBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.m_237115_((String)"block.phi.mpu.desc"));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack item = player.m_21120_(hand);
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof MPUTile)) {
            return InteractionResult.PASS;
        }
        if (item.m_41720_() == Items.f_41978_) {
            ((MPUTile)tile).redstoneMode = RedstoneMode.values()[(((MPUTile)tile).redstoneMode.ordinal() + 1) % RedstoneMode.values().length];
            player.m_5661_((Component)Component.m_237115_((String)("phi.redstone_mode." + String.valueOf((Object)((MPUTile)tile).redstoneMode))), true);
            return InteractionResult.SUCCESS;
        }
        Class<?> spellDrive = null;
        try {
            spellDrive = Class.forName("vazkii.psi.common.item.ItemSpellDrive");
            if (!((Boolean)Class.forName("vazkii.psi.common.item.ItemCAD").getMethod("isTruePlayer", Entity.class).invoke(null, player)).booleanValue()) {
                return InteractionResult.PASS;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Spell spell = null;
        if (spellDrive != null && spellDrive.isInstance(item.m_41720_())) {
            try {
                spell = (Spell)spellDrive.getMethod("getSpell", ItemStack.class).invoke((Object)item.m_41720_(), item);
            }
            catch (Exception e) {
                e.printStackTrace();
                return InteractionResult.PASS;
            }
        } else {
            if (!ISpellAcceptor.isAcceptor((ItemStack)item)) {
                return InteractionResult.PASS;
            }
            ISpellAcceptor acceptor = ISpellAcceptor.acceptor((ItemStack)item);
            if (!acceptor.containsSpell()) {
                return InteractionResult.PASS;
            }
            spell = acceptor.getSpell();
        }
        if (!world.f_46443_ && spell != null) {
            ((MPUTile)tile).setSpell(spell);
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_());
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.f_46443_) {
            CableNetwork.rebuild(world, pos);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean flag) {
        super.m_6810_(state, world, pos, newState, flag);
        if (!world.f_46443_) {
            CableNetwork.rebuild(world, pos);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MPUTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return type != MPUTile.type ? null : (level, pos, state1, tile) -> ((MPUTile)tile).tick();
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof MPUTile)) {
            return 0;
        }
        return ((MPUTile)tile).comparatorSignal;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }
}

