/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block;

import gdavid.phi.block.tile.SpellDisplayTile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemSpellDrive;

public class SpellDisplayBlock
extends DirectionalBlock
implements EntityBlock {
    public static final String id = "spell_display";
    private static final Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();

    public SpellDisplayBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.m_237115_((String)"block.phi.spell_display.desc"));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack item = player.m_21120_(hand);
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof SpellDisplayTile)) {
            return InteractionResult.PASS;
        }
        Spell spell = ((SpellDisplayTile)tile).getSpell();
        if (spell == null) {
            return InteractionResult.PASS;
        }
        if (item.m_41720_() instanceof ItemSpellDrive) {
            if (!world.f_46443_) {
                world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, PsiSoundHandler.bulletCreate, SoundSource.BLOCKS, 0.5f, 1.0f);
                ItemSpellDrive.setSpell((ItemStack)item, (Spell)spell);
            }
        } else {
            if (!ISpellAcceptor.isAcceptor((ItemStack)item)) {
                return InteractionResult.PASS;
            }
            ISpellAcceptor acceptor = ISpellAcceptor.acceptor((ItemStack)item);
            if (!world.f_46443_) {
                world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, PsiSoundHandler.bulletCreate, SoundSource.BLOCKS, 0.5f, 1.0f);
                acceptor.setSpell(player, spell);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shapes.get(state.m_61143_((Property)f_52588_));
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_7820_().m_122424_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SpellDisplayTile(pos, state);
    }

    static {
        shapes.put(Direction.UP, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0));
        shapes.put(Direction.DOWN, Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        shapes.put(Direction.NORTH, Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0));
        shapes.put(Direction.SOUTH, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0));
        shapes.put(Direction.WEST, Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        shapes.put(Direction.EAST, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0));
    }
}

