/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block.tile;

import gdavid.phi.network.CADScanMessage;
import gdavid.phi.network.Messages;
import gdavid.phi.util.IProgramTransferTarget;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.item.ItemSpellDrive;

public class CADHolderTile
extends BlockEntity
implements IProgramTransferTarget {
    public static BlockEntityType<CADHolderTile> type;
    public static final String tagItem = "item";
    public ItemStack item = ItemStack.f_41583_;
    public ScanType scan = ScanType.none;
    public long scanTime;

    public CADHolderTile(BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean hasItem() {
        return !this.item.m_41619_();
    }

    public void setItem(ItemStack stack) {
        this.item = stack;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
    }

    public void removeItem() {
        this.setItem(ItemStack.f_41583_);
    }

    @Override
    public BlockPos getPosition() {
        return this.f_58858_;
    }

    @Override
    public Spell getSpell() {
        ISocketable socketable;
        Spell spell;
        this.setScanType(ScanType.scan);
        if (this.item.m_41720_() instanceof ItemSpellDrive) {
            return ItemSpellDrive.getSpell((ItemStack)this.item);
        }
        ISpellAcceptor acceptor = (ISpellAcceptor)this.item.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).orElse(null);
        Spell spell2 = spell = acceptor == null ? null : acceptor.getSpell();
        if (spell == null && (socketable = (ISocketable)this.item.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).orElse(null)) != null) {
            acceptor = (ISpellAcceptor)socketable.getSelectedBullet().getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).orElse(null);
            spell = acceptor == null ? null : acceptor.getSpell();
        }
        return spell;
    }

    @Override
    public void setSpell(Player player, Spell spell) {
        this.setScanType(ScanType.reprogram);
        if (this.item.m_41720_() instanceof ItemSpellDrive) {
            ItemSpellDrive.setSpell((ItemStack)this.item, (Spell)spell);
            this.m_6596_();
            return;
        }
        this.item.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).ifPresent(acceptor -> {
            acceptor.setSpell(player, spell);
            this.m_6596_();
        });
    }

    @Override
    public boolean hasSlots() {
        return this.item.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).isPresent();
    }

    @Override
    public List<Integer> getSlots() {
        ISocketable socketable = (ISocketable)this.item.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).orElse(null);
        if (socketable == null) {
            return null;
        }
        return socketable.getRadialMenuSlots();
    }

    @Override
    public List<ResourceLocation> getSlotIcons() {
        ISocketable socketable = (ISocketable)this.item.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).orElse(null);
        if (socketable == null) {
            return null;
        }
        return socketable.getRadialMenuIcons();
    }

    @Override
    public void selectSlot(int id) {
        this.item.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).ifPresent(socketable -> {
            socketable.setSelectedSlot(id);
            this.m_6596_();
        });
    }

    public void setScanType(ScanType type) {
        if (this.f_58857_.f_46443_) {
            if (this.scan.ordinal() > type.ordinal()) {
                return;
            }
            if (this.scan == ScanType.none) {
                this.scanTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() > this.scanTime + 1000L) {
                this.scanTime = 2L * System.currentTimeMillis() - this.scanTime - 2000L;
            }
            this.scan = type;
        } else {
            CADScanMessage message = new CADScanMessage(this.f_58858_, type);
            Messages.channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)64.0, (ResourceKey)this.f_58857_.m_46472_())), (Object)message);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.item = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(tagItem));
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_(tagItem, (Tag)this.item.m_41739_(new CompoundTag()));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public static enum ScanType {
        none(null),
        scan(new ResourceLocation("phi", "textures/block/cad_holder_scan.png")),
        reprogram(new ResourceLocation("phi", "textures/block/cad_holder_reprogram.png"));

        public final ResourceLocation texture;

        private ScanType(ResourceLocation texture) {
            this.texture = texture;
        }
    }
}

