/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block.tile;

import gdavid.phi.block.CableBlock;
import gdavid.phi.cable.ICableConnected;
import gdavid.phi.cable.ICableSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CableTile
extends BlockEntity
implements ICableSegment {
    public static BlockEntityType<CableTile> type;
    public static final String tagConnection = "connection";
    @Nullable
    public BlockPos connected = null;

    public CableTile(BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public BlockPos getConnection() {
        return this.connected;
    }

    @Override
    public void setConnection(@Nullable BlockPos connection, Predicate<BlockPos> connected) {
        this.connected = connection;
        this.m_6596_();
        BlockState state = this.m_58900_();
        state = (BlockState)state.m_61124_((Property)CableBlock.online, (Comparable)Boolean.valueOf(connection != null));
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            CableBlock.CableSide side = CableBlock.CableSide.none;
            if (connected.test(this.f_58858_.m_121945_(dir).m_121945_(Direction.UP))) {
                side = CableBlock.CableSide.up;
            } else if (connected.test(this.f_58858_.m_121945_(dir)) || connected.test(this.f_58858_.m_121945_(dir).m_121945_(Direction.DOWN))) {
                side = CableBlock.CableSide.side;
            }
            state = (BlockState)state.m_61124_((Property)CableBlock.sides.get(dir), (Comparable)((Object)side));
        }
        this.f_58857_.m_46597_(this.f_58858_, state);
    }

    @Override
    public Iterable<BlockPos> getNeighbours() {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            this.tryAddNeighbour(res, this.f_58858_.m_121945_(dir), dir.m_122424_(), true);
        }
        this.tryAddNeighbour(res, this.f_58858_.m_121945_(Direction.DOWN), Direction.UP, false);
        return res;
    }

    void tryAddNeighbour(List<BlockPos> to, BlockPos pos, Direction side, boolean stepUp) {
        BlockEntity tile = this.f_58857_.m_7702_(pos);
        if (tile instanceof ICableConnected || tile instanceof ICableSegment && ((ICableSegment)tile).canConnect(side)) {
            to.add(pos);
        } else if (stepUp) {
            this.tryAddNeighbour(to, pos.m_121945_(Direction.UP), side, false);
            this.tryAddNeighbour(to, pos.m_121945_(Direction.DOWN), side, false);
        }
    }

    @Override
    public boolean canConnect(Direction side) {
        return side != Direction.UP;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.connected = nbt.m_128441_(tagConnection) ? BlockPos.m_122022_((long)nbt.m_128454_(tagConnection)) : null;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.connected != null) {
            nbt.m_128356_(tagConnection, this.connected.m_121878_());
        } else {
            nbt.m_128473_(tagConnection);
        }
    }
}

