/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block.tile;

import gdavid.phi.block.DistillChamberControllerBlock;
import gdavid.phi.block.DistillChamberWallBlock;
import gdavid.phi.entity.PsiProjectileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.psi.common.lib.ModTags;

public class DistillChamberControllerTile
extends BlockEntity {
    public static BlockEntityType<DistillChamberControllerTile> type;
    public static final String tagFuel = "fuel";
    public static final String tagItem = "item";
    public static final String tagValue = "value";
    public static final String tagPsi = "psi";
    private static final int storagePerBlock = 4;
    private List<Pair<ItemStack, Integer>> fuel = new ArrayList<Pair<ItemStack, Integer>>();
    private int psi = 0;

    public DistillChamberControllerTile(BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        ItemEntity item;
        int size = this.getStructureVolume();
        this.producePsi(size);
        if (this.psi >= 100) {
            PsiProjectileEntity projectile = new PsiProjectileEntity(this.f_58857_, Vec3.m_82528_((Vec3i)((Direction)this.m_58900_().m_61143_((Property)DistillChamberControllerBlock.f_52588_)).m_122436_()), this.psi);
            projectile.m_6034_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5);
            projectile.setOrigin();
            this.f_58857_.m_7967_((Entity)projectile);
            this.psi = 0;
            this.m_6596_();
        }
        if (this.fuel.size() < size * 4 && (item = this.getFuelItem()) != null) {
            ItemStack stack = item.m_32055_();
            ItemStack fuelStack = stack.m_41620_(1);
            this.fuel.add((Pair<ItemStack, Integer>)Pair.of((Object)fuelStack, (Object)this.getValue(fuelStack)));
            if (stack.m_41619_()) {
                item.m_146870_();
            } else {
                item.m_32045_(stack);
            }
            this.m_6596_();
        }
    }

    private void producePsi(int size) {
        int amount = 0;
        boolean changed = false;
        for (int i = 0; i < this.fuel.size() && amount < size; ++i) {
            ItemStack stack = (ItemStack)this.fuel.get(i).getKey();
            int value = (Integer)this.fuel.get(i).getValue();
            ++amount;
            if (value > 1) {
                this.fuel.set(i, (Pair<ItemStack, Integer>)Pair.of((Object)stack, (Object)(value - 1)));
            } else if (stack.m_41619_()) {
                this.fuel.remove(i--);
            } else {
                stack.m_41774_(1);
                this.fuel.set(i, (Pair<ItemStack, Integer>)Pair.of((Object)stack, (Object)this.getValue(stack)));
            }
            changed = true;
        }
        this.psi += amount;
        if (changed) {
            this.m_6596_();
        }
    }

    private ItemEntity getFuelItem() {
        AABB aabb = AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)DistillChamberControllerBlock.f_52588_))), (double)1.0, (double)1.0, (double)1.0);
        List items = this.f_58857_.m_45976_(ItemEntity.class, aabb);
        return items.stream().filter(item -> item.m_32055_().m_204117_(ModTags.PSIDUST)).findAny().orElse(null);
    }

    private int getValue(ItemStack stack) {
        if (stack.m_204117_(ModTags.PSIDUST)) {
            return 625;
        }
        return 0;
    }

    private int getStructureVolume() {
        Direction dir = ((Direction)this.m_58900_().m_61143_((Property)DistillChamberControllerBlock.f_52588_)).m_122424_();
        HashMap<Direction, Integer> edges = new HashMap<Direction, Integer>(6);
        BlockPos edgePos = null;
        for (Direction side : Direction.values()) {
            if (side.m_122434_() == dir.m_122434_()) continue;
            int i = this.findEdge(this.f_58858_, side);
            int opos = side.m_122434_().m_7863_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
            opos = side.m_122421_() == Direction.AxisDirection.POSITIVE ? (opos += i) : (opos -= i);
            edges.put(side, opos);
            if (edgePos != null) continue;
            edgePos = this.f_58858_.m_5484_(side, i * side.m_122421_().m_122540_());
        }
        int depth = this.findEdge(edgePos, dir);
        edges.put(dir, dir.m_122434_().m_7863_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_()) + depth * dir.m_122421_().m_122540_());
        edges.put(dir.m_122424_(), dir.m_122434_().m_7863_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_()));
        int x1 = (Integer)edges.get(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)Direction.Axis.X));
        int y1 = (Integer)edges.get(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)Direction.Axis.Y));
        int z1 = (Integer)edges.get(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)Direction.Axis.Z));
        int x2 = (Integer)edges.get(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)Direction.Axis.X));
        int y2 = (Integer)edges.get(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)Direction.Axis.Y));
        int z2 = (Integer)edges.get(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)Direction.Axis.Z));
        if (!this.verifyStructure(x1, y1, z1, x2, y2, z2)) {
            return 0;
        }
        return (x2 - x1 - 1) * (y2 - y1 - 1) * (z2 - z1 - 1);
    }

    private boolean verifyStructure(int x1, int y1, int z1, int x2, int y2, int z2) {
        if (x2 <= x1 || y2 <= y1 || z2 <= z1) {
            return false;
        }
        if (x2 - x1 - 1 > 3 || y2 - y1 - 1 > 3 || z2 - z1 - 1 > 3) {
            return false;
        }
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (pos.equals((Object)this.f_58858_)) continue;
                    BlockState state = this.f_58857_.m_8055_(pos);
                    if (!(x == x1 || x == x2 || y == y1 || y == y2 || z == z1 || z == z2 ? !(state.m_60734_() instanceof DistillChamberWallBlock) : !state.m_60795_())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private int findEdge(BlockPos from, Direction side) {
        int i = 0;
        while (this.f_58857_.m_8055_(from.m_5484_(side, i + 1)).m_60734_() instanceof DistillChamberWallBlock) {
            ++i;
        }
        return i;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ListTag fuel = nbt.m_128437_(tagFuel, 10);
        this.fuel.clear();
        for (int i = 0; i < fuel.size(); ++i) {
            CompoundTag item = fuel.m_128728_(i);
            this.fuel.add((Pair<ItemStack, Integer>)Pair.of((Object)ItemStack.m_41712_((CompoundTag)item.m_128469_(tagItem)), (Object)item.m_128451_(tagValue)));
        }
        this.psi = nbt.m_128451_(tagPsi);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ListTag list = new ListTag();
        for (Pair<ItemStack, Integer> pair : this.fuel) {
            CompoundTag item = new CompoundTag();
            item.m_128365_(tagItem, (Tag)((ItemStack)pair.getKey()).m_41739_(new CompoundTag()));
            item.m_128405_(tagValue, ((Integer)pair.getValue()).intValue());
            list.add((Object)item);
        }
        nbt.m_128365_(tagFuel, (Tag)list);
        nbt.m_128405_(tagPsi, this.psi);
    }
}

