/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block.tile;

import com.mojang.authlib.GameProfile;
import gdavid.phi.block.MPUBlock;
import gdavid.phi.cable.CableNetwork;
import gdavid.phi.cable.ICableConnected;
import gdavid.phi.item.MPUCAD;
import gdavid.phi.spell.trick.evaluation.ReevaluateTrick;
import gdavid.phi.spell.trick.marker.MoveMarkerTrick;
import gdavid.phi.util.IProgramTransferTarget;
import gdavid.phi.util.IPsiAcceptor;
import gdavid.phi.util.IWaveImpacted;
import gdavid.phi.util.RedstoneMode;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingPlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellPiece;

public class MPUTile
extends BlockEntity
implements ICableConnected,
IProgramTransferTarget,
IWaveImpacted,
IPsiAcceptor {
    public static BlockEntityType<MPUTile> type;
    public static final int complexityPerTick = 5;
    public static final Component statError;
    public static final String tagSpell = "spell";
    public static final String tagPsi = "psi";
    public static final String tagMessage = "message";
    public static final String tagNearbySpeech = "nearby_speech";
    public static final String tagComparatorSignal = "comparator_signal";
    public static final String tagSuccessCount = "success_count";
    public static final String tagRedstoneMode = "redstoneMode";
    public static final String tagCad = "cad";
    public Spell spell;
    public int psi;
    public Component message;
    public String nearbySpeech = "";
    public int comparatorSignal;
    public int successCount;
    public RedstoneMode redstoneMode = RedstoneMode.always;
    public boolean prevRedstoneSignal;
    public boolean redstoneSignal;
    public MPUCaster caster;
    public ItemStack cad = new ItemStack((ItemLike)MPUCAD.instance);
    public WeakReference<SpellContext> context;
    public int castDelay;
    public int prevPsi;

    public MPUTile(BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public BlockPos getPosition() {
        return this.f_58858_;
    }

    @Override
    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public void setSpell(Player player, Spell spell) {
        this.setSpell(spell);
    }

    public void setSpell(Spell to) {
        if (to == null) {
            this.spell = null;
        } else {
            this.spell = to.copy();
            this.spell.uuid = UUID.randomUUID();
        }
        this.message = null;
        this.successCount = 0;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
    }

    @Override
    public void addPsi(int amount) {
        if (amount == 0) {
            return;
        }
        this.psi = Math.max(0, Math.min(this.getPsiCapacity(), this.psi + amount));
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
    }

    public int getPsiCapacity() {
        return 1000;
    }

    public void setTime(int time) {
        MPUCAD.instance.setTime(this.cad, time);
        this.m_6596_();
    }

    @Override
    public void waveImpact(Float frequency, float focus) {
        this.addPsi(-Math.round(frequency.floatValue() * focus * 4.0f));
        this.castDelay = Math.round(frequency.floatValue() * focus * 4.0f);
    }

    public void setNearbySpeech(String to) {
        this.nearbySpeech = to;
        this.m_6596_();
    }

    public void tick() {
        boolean recast;
        if (this.f_58857_.f_46443_) {
            this.prevPsi = this.psi < this.prevPsi ? Math.max(this.psi, this.prevPsi - 25) : this.psi;
            return;
        }
        MPUCAD.instance.incrementTime(this.cad);
        this.prevRedstoneSignal = this.redstoneSignal;
        this.redstoneSignal = this.f_58857_.m_46753_(this.m_58899_());
        if (this.spell == null) {
            return;
        }
        if (this.caster == null) {
            this.caster = new MPUCaster();
        }
        this.caster.fix();
        if (this.castDelay > 0) {
            --this.castDelay;
            return;
        }
        if (!this.redstoneMode.isActive(this.prevRedstoneSignal, this.redstoneSignal)) {
            return;
        }
        boolean bl = recast = this.context == null || this.context.get() == null;
        if (!recast) {
            try {
                recast = !((Set)Class.forName("vazkii.psi.common.core.handler.PlayerDataHandler").getField("delayedContexts").get(null)).contains(this.context.get());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (recast) {
            SpellContext ctx = new SpellContext().setPlayer((Player)this.caster).setSpell(this.spell);
            this.context = new WeakReference<SpellContext>(ctx);
            if (!ctx.isValid()) {
                return;
            }
            if (!ctx.cspell.metadata.evaluateAgainst(this.cad)) {
                if (this.message != statError) {
                    this.message = statError;
                    this.m_6596_();
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
                }
                return;
            }
            int cost = ctx.cspell.metadata.getStat(EnumSpellStat.COST);
            if (cost == 0 && this.minCostFix(this.spell)) {
                cost = 1;
            }
            if (this.psi < cost) {
                return;
            }
            this.addPsi(-cost);
            this.castDelay = ctx.cspell.metadata.getStat(EnumSpellStat.COMPLEXITY) / 5;
            if (ctx.cspell.metadata.getFlag("phi:psi_transfer")) {
                this.castDelay = Math.max(this.castDelay, 4);
            }
            ctx.cspell.safeExecute(ctx);
            ++this.successCount;
            this.m_6596_();
        }
    }

    public boolean minCostFix(Spell spell) {
        SpellPiece[][] spellPieceArray = spell.grid.gridData;
        int n = spellPieceArray.length;
        for (int i = 0; i < n; ++i) {
            SpellPiece[] pieces;
            for (SpellPiece piece : pieces = spellPieceArray[i]) {
                if (piece == null || piece.getPieceType() != EnumPieceType.TRICK) continue;
                try {
                    String name;
                    SpellMetadata meta = new SpellMetadata();
                    piece.addToMetadata(meta);
                    if (meta.getStat(EnumSpellStat.PROJECTION) == 0 || (name = piece.getClass().getName()).equals("vazkii.psi.common.spell.trick.PieceTrickParticleTrail") || name.equals("vazkii.psi.common.spell.trick.PieceTrickPlaySound") || piece instanceof MoveMarkerTrick || piece instanceof ReevaluateTrick) continue;
                    return true;
                }
                catch (SpellCompilationException spellCompilationException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (this.spell == null) {
            this.spell = Spell.createFromNBT((CompoundTag)nbt.m_128469_(tagSpell));
        } else {
            this.spell.readFromNBT(nbt.m_128469_(tagSpell));
        }
        this.psi = nbt.m_128451_(tagPsi);
        MPUCAD.instance.getData(this.cad).deserializeNBT((Tag)nbt.m_128469_(tagCad));
        this.message = Component.Serializer.m_130701_((String)nbt.m_128461_(tagMessage));
        this.nearbySpeech = nbt.m_128461_(tagNearbySpeech);
        this.comparatorSignal = nbt.m_128451_(tagComparatorSignal);
        this.successCount = nbt.m_128451_(tagSuccessCount);
        this.redstoneMode = RedstoneMode.values()[nbt.m_128451_(tagRedstoneMode)];
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag spellNbt = new CompoundTag();
        if (this.spell != null) {
            this.spell.writeToNBT(spellNbt);
        }
        nbt.m_128365_(tagSpell, (Tag)spellNbt);
        nbt.m_128405_(tagPsi, this.psi);
        nbt.m_128365_(tagCad, MPUCAD.instance.getData(this.cad).serializeNBT());
        nbt.m_128359_(tagMessage, Component.Serializer.m_130703_((Component)this.message));
        nbt.m_128359_(tagNearbySpeech, this.nearbySpeech);
        nbt.m_128405_(tagComparatorSignal, this.comparatorSignal);
        nbt.m_128405_(tagSuccessCount, this.successCount);
        nbt.m_128405_(tagRedstoneMode, this.redstoneMode.ordinal());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    @Override
    public boolean isController() {
        return false;
    }

    static {
        statError = Component.m_237115_((String)"psimisc.weak_cad");
    }

    public class MPUCaster
    extends FakePlayer {
        private MPUCaster() {
            super((ServerLevel)MPUTile.this.f_58857_, new GameProfile(UUID.randomUUID(), "MPU"));
            this.f_8906_ = new ServerGamePacketListenerImpl(this.f_8924_, new Connection(PacketFlow.SERVERBOUND){

                public void m_243124_(Packet<?> packet, PacketSendListener listener) {
                }
            }, (ServerPlayer)this);
            this.m_150109_().f_35974_.set(0, (Object)MPUTile.this.cad);
            this.f_19816_ = 0.0f;
        }

        public Vec3 m_20182_() {
            return new Vec3((double)MPUTile.this.f_58858_.m_123341_() + 0.5, (double)MPUTile.this.f_58858_.m_123342_() + 0.5, (double)MPUTile.this.f_58858_.m_123343_() + 0.5);
        }

        public BlockPos m_20183_() {
            return MPUTile.this.f_58858_;
        }

        public Vec3 m_20154_() {
            return Vec3.m_82528_((Vec3i)((Direction)this.m_146900_().m_61143_((Property)MPUBlock.f_54117_)).m_122436_());
        }

        public void fix() {
            float yaw = ((Direction)this.m_146900_().m_61143_((Property)MPUBlock.f_54117_)).m_122435_();
            this.m_19890_((double)MPUTile.this.f_58858_.m_123341_() + 0.5, (double)MPUTile.this.f_58858_.m_123342_() + 0.5, (double)MPUTile.this.f_58858_.m_123343_() + 0.5, yaw, 0.0f);
            this.f_20885_ = this.m_146908_();
        }

        public void m_240418_(Component component, boolean bypassHidden) {
            this.sendMessage(component);
        }

        public void m_243093_(OutgoingPlayerChatMessage message, boolean filter, ChatType.Bound bound) {
            this.sendMessage(message.m_240962_());
        }

        private void sendMessage(Component component) {
            MPUTile.this.message = component;
            MPUTile.this.m_6596_();
            MPUTile.this.f_58857_.m_7260_(MPUTile.this.f_58858_, this.m_146900_(), this.m_146900_(), 18);
        }

        public void deductPsi(int amount, int cd) {
            MPUTile.this.addPsi(-amount);
            MPUTile.this.castDelay += cd;
        }

        public int getPsi() {
            return MPUTile.this.psi;
        }

        public int getMaxPsi() {
            return MPUTile.this.getPsiCapacity();
        }

        public void setComparatorSignal(int value) {
            MPUTile.this.comparatorSignal = Math.max(Math.min(value, 15), 0);
            MPUTile.this.m_6596_();
            MPUTile.this.f_58857_.m_7260_(MPUTile.this.f_58858_, this.m_146900_(), this.m_146900_(), 3);
        }

        public void setTime(int time) {
            MPUTile.this.setTime(time);
        }

        public BlockPos getConnected(Direction side) {
            return CableNetwork.getController(this.f_19853_, MPUTile.this.f_58858_, side);
        }

        public int getSuccessCount() {
            return MPUTile.this.successCount;
        }

        public String getNearbySpeech() {
            return MPUTile.this.nearbySpeech;
        }

        public void fail() {
            MPUTile.this.successCount = 0;
            MPUTile.this.m_6596_();
        }
    }
}

