/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block.tile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.psi.common.Psi;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.lib.ModTags;

public class PsimetalCrusherTile
extends BlockEntity {
    public static BlockEntityType<PsimetalCrusherTile> type;
    public static final String tagProgress = "progress";
    private static final int duration = 60;
    private static final int craftTime = 5;
    public int progress = 0;

    public PsimetalCrusherTile(BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public double getPistonOffset(float partialTicks) {
        float time = (float)(60 - this.progress) + partialTicks;
        if (time <= 0.0f) {
            return 0.0;
        }
        if (time < 5.0f) {
            return time / 5.0f;
        }
        return Math.pow(1.0f - (time - 5.0f) / 55.0f, 2.0);
    }

    public void tick() {
        if (this.progress > 0) {
            ItemEntity item;
            --this.progress;
            if (this.progress == 55 && (item = this.getItemUnder()) != null) {
                ItemStack stack = item.m_32055_();
                ItemStack from = stack.m_41620_(1);
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, item.m_20185_(), item.m_20186_() + (double)(item.m_20206_() / 2.0f), item.m_20189_(), PsimetalCrusherTile.getResult(from)));
                if (stack.m_41619_()) {
                    item.m_146870_();
                } else {
                    item.m_32045_(stack);
                }
                int color = 1295871;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                for (int i = 0; i < 10; ++i) {
                    Psi.proxy.sparkleFX(item.m_20185_(), item.m_20186_(), item.m_20189_(), r, g, b, (float)this.f_58857_.f_46441_.m_188583_() * 0.05f, (float)this.f_58857_.f_46441_.m_188583_() * 0.05f, (float)this.f_58857_.f_46441_.m_188583_() * 0.05f, 3.5f, 15);
                }
            }
        } else if (this.getItemUnder() != null) {
            this.progress = 60;
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
        }
    }

    private static ItemStack getResult(ItemStack stack) {
        if (stack.m_204117_(ModTags.INGOT_PSIMETAL)) {
            return new ItemStack((ItemLike)ModItems.psidust, 8);
        }
        return ItemStack.f_41583_;
    }

    private ItemEntity getItemUnder() {
        AABB aabb = AABB.m_165882_((Vec3)Vec3.m_82514_((Vec3i)this.f_58858_, (double)-1.0), (double)0.8, (double)1.0, (double)0.8);
        List items = this.f_58857_.m_45976_(ItemEntity.class, aabb);
        return items.stream().filter(item -> item.m_32055_().m_204117_(ModTags.INGOT_PSIMETAL)).findAny().orElse(null);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(tagProgress, this.progress);
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.progress = packet.m_131708_().m_128451_(tagProgress);
    }
}

