/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block.tile;

import gdavid.phi.util.IProgramTransferTarget;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.psi.api.spell.Spell;

public class SpellStorageTile
extends BlockEntity
implements IProgramTransferTarget {
    public static BlockEntityType<SpellStorageTile> type;
    public static final String tagSpell = "spell_";
    public static final String tagSelectedSlot = "selected_slot";
    public static final int slots = 15;
    public Spell[] spells = new Spell[15];
    public int selectedSlot = 0;

    public SpellStorageTile(BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public BlockPos getPosition() {
        return this.f_58858_;
    }

    @Override
    public Spell getSpell() {
        return this.spells[this.selectedSlot];
    }

    @Override
    public void setSpell(Player player, Spell spell) {
        this.spells[this.selectedSlot] = spell;
        this.m_6596_();
    }

    @Override
    public boolean hasSlots() {
        return true;
    }

    @Override
    public List<Integer> getSlots() {
        return Stream.iterate(0, x -> x + 1).limit(15L).collect(Collectors.toList());
    }

    @Override
    public List<ResourceLocation> getSlotIcons() {
        return Stream.iterate(0, x -> x + 1).limit(15L).map(x -> new ResourceLocation("phi", "textures/gui/signs/spell_storage_" + x + ".png")).collect(Collectors.toList());
    }

    @Override
    public void selectSlot(int id) {
        if (id < 0 || id >= 15) {
            return;
        }
        this.selectedSlot = id;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        for (int i = 0; i < 15; ++i) {
            this.spells[i] = Spell.createFromNBT((CompoundTag)nbt.m_128469_(tagSpell + i));
        }
        this.selectedSlot = nbt.m_128451_(tagSelectedSlot);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        for (int i = 0; i < 15; ++i) {
            CompoundTag spellNbt = new CompoundTag();
            if (this.spells[i] != null) {
                this.spells[i].writeToNBT(spellNbt);
            }
            nbt.m_128365_(tagSpell + i, (Tag)spellNbt);
        }
        nbt.m_128405_(tagSelectedSlot, this.selectedSlot);
    }
}

