/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block.tile;

import gdavid.phi.cable.ICableConnected;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TextDisplayTile
extends BlockEntity
implements ICableConnected {
    public static BlockEntityType<TextDisplayTile> type;
    public static final String tagText = "text";
    public static final int lines = 16;
    public static final int columns = 32;
    public List<String> text = new ArrayList<String>();

    public TextDisplayTile(BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void appendLine(String line) {
        for (String actualLine : this.normalizeFormatting(line)) {
            this.text.add(actualLine);
            if (this.text.size() <= 16) continue;
            this.text.remove(0);
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
    }

    public void setLine(String line, int index) {
        if (index < 1 || index > 16) {
            return;
        }
        while (index > this.text.size()) {
            this.text.add("");
        }
        for (String actualLine : this.normalizeFormatting(line)) {
            if (index > this.text.size()) {
                this.text.add("");
            }
            this.text.set(index++ - 1, actualLine);
            if (index <= 16) continue;
            return;
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
    }

    private List<String> normalizeFormatting(String str) {
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        int column = 0;
        char curColor = '\u0000';
        boolean[] curFormats = new boolean[5];
        int i = 0;
        while (i < str.length()) {
            int nl;
            char color = '\u0000';
            boolean[] formats = new boolean[5];
            boolean reset = false;
            while (i + 1 < str.length() && str.charAt(i) == '\u00a7') {
                char code = Character.toLowerCase(str.charAt(i + 1));
                if (code == 'r') {
                    reset = true;
                    color = '\u0000';
                    curColor = '\u0000';
                    Arrays.fill(formats, false);
                    Arrays.fill(curFormats, false);
                } else if (code >= '0' && code <= '9' || code >= 'a' && code <= 'f') {
                    curColor = color = code;
                    Arrays.fill(formats, false);
                    Arrays.fill(curFormats, false);
                } else {
                    if (code < 107 || code > 111) break;
                    formats[code - 107] = true;
                    curFormats[code - 107] = true;
                }
                i += 2;
            }
            if (reset) {
                b.append("\u00a7r");
            }
            if (color != '\u0000') {
                b.append('\u00a7').append(color);
            }
            for (int f = 0; f < 5; ++f) {
                if (!formats[f]) continue;
                b.append('\u00a7').append((char)(107 + f));
            }
            int from = i;
            if ((i = str.indexOf(167, from)) == -1) {
                i = str.length();
            }
            if ((nl = str.indexOf(10, from)) != -1 && nl < i) {
                i = nl;
            }
            if (column + i - from > 32) {
                i = from + 32 - column;
            }
            b.append(str, from, i);
            if ((column += i - from) < 32 && nl != i) continue;
            if (nl == i) {
                ++i;
            }
            column = 0;
            res.add(b.toString());
            b = new StringBuilder();
            if (curColor != '\u0000') {
                b.append('\u00a7').append(curColor);
            }
            for (int f = 0; f < 5; ++f) {
                if (!curFormats[f]) continue;
                b.append('\u00a7').append((char)(107 + f));
            }
        }
        res.add(b.toString());
        return res;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.text = new ArrayList<String>();
        for (Tag line : nbt.m_128437_(tagText, 8)) {
            this.text.add(line.m_7916_());
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ListTag list = new ListTag();
        for (String line : this.text) {
            list.add((Object)StringTag.m_129297_((String)line));
        }
        nbt.m_128365_(tagText, (Tag)list);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    @Override
    public boolean isController() {
        return true;
    }
}

