/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block.tile.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import gdavid.phi.block.MPUBlock;
import gdavid.phi.block.tile.MPUTile;
import gdavid.phi.util.RedstoneMode;
import gdavid.phi.util.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MPUTileRenderer
implements BlockEntityRenderer<MPUTile> {
    public static final ResourceLocation psiBarTexture = new ResourceLocation("psi", "textures/gui/psi_bar.png");
    public static final int w = 174;
    public static final int h = 184;
    public static final int bw = 24;
    public static final int bh = 132;
    public static final int light = 0xF000F0;

    public MPUTileRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(MPUTile mpu, float partialTicks, PoseStack ms, MultiBufferSource buf, int worldLight, int overlay) {
        ms.m_85836_();
        this.setupTransform(mpu, ms, 201, 184);
        this.drawSpell(mpu, ms, buf, 0xF000F0);
        ms.m_85836_();
        ms.m_85837_(177.0, 26.0, 0.0);
        this.drawPsiBar(mpu, ms, buf, 0xF000F0);
        ms.m_85849_();
        ms.m_85836_();
        ms.m_85837_(-7.0, -26.0, 0.0);
        this.drawRedstoneMode(mpu, ms, buf, 0xF000F0);
        ms.m_85849_();
        if (mpu.message != null) {
            ms.m_85836_();
            Minecraft.m_91087_().f_91062_.m_92811_(mpu.message.getString(), 0.0f, 184.0f, 0xFFFFFF, false, ms.m_85850_().m_85861_(), buf, false, 0, 0xF000F0);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    public void setupTransform(MPUTile mpu, PoseStack ms, int width, int height) {
        ms.m_85837_(0.5, (double)1.62f, 0.5);
        ms.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        ms.m_85845_(Vector3f.f_122225_.m_122240_(((Direction)mpu.m_58900_().m_61143_((Property)MPUBlock.f_54117_)).m_122435_()));
        ms.m_85837_(0.0, 0.0, 0.5);
        ms.m_85845_(Vector3f.f_122223_.m_122240_(-60.0f));
        ms.m_85841_(0.0033333334f, 0.0033333334f, -0.0033333334f);
        ms.m_85837_((double)((float)(-width) / 2.0f), (double)((float)height / 2.0f), 0.0);
    }

    public void drawSpell(MPUTile mpu, PoseStack ms, MultiBufferSource buf, int light) {
        Minecraft mc = Minecraft.m_91087_();
        try {
            VertexConsumer buffer = buf.m_6299_((RenderType)Class.forName("vazkii.psi.client.gui.GuiProgrammer").getField("LAYER").get(null));
            Matrix4f mat = ms.m_85850_().m_85861_();
            buffer.m_85982_(mat, -7.0f, 177.0f, -0.01f).m_6122_(255, 255, 255, 128).m_7421_(0.0f, 0.71875f).m_85969_(light).m_5752_();
            buffer.m_85982_(mat, 167.0f, 177.0f, -0.01f).m_6122_(255, 255, 255, 128).m_7421_(0.6796875f, 0.71875f).m_85969_(light).m_5752_();
            buffer.m_85982_(mat, 167.0f, -7.0f, -0.01f).m_6122_(255, 255, 255, 128).m_7421_(0.6796875f, 0.0f).m_85969_(light).m_5752_();
            buffer.m_85982_(mat, -7.0f, -7.0f, -0.01f).m_6122_(255, 255, 255, 128).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mc.f_91062_.m_92811_(I18n.m_118938_((String)"psimisc.name", (Object[])new Object[0]), 0.0f, 164.0f, 0xFFFFFF, false, ms.m_85850_().m_85861_(), buf, false, 0, light);
        if (mpu.spell != null && !mpu.spell.grid.isEmpty()) {
            mpu.spell.draw(ms, buf, light);
            mc.f_91062_.m_92811_(mpu.spell.name, 38.0f, 164.0f, 0xFFFFFF, false, ms.m_85850_().m_85861_(), buf, false, 0, light);
        }
    }

    public void drawPsiBar(MPUTile mpu, PoseStack ms, MultiBufferSource buf, int light) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)psiBarTexture);
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, (double)-0.01f);
        RenderSystem.m_69464_();
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GuiComponent.m_93133_((PoseStack)ms, (int)0, (int)0, (float)4.0f, (float)6.0f, (int)24, (int)132, (int)64, (int)256);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.m_85849_();
        float percent = (float)mpu.psi / (float)mpu.getPsiCapacity();
        float percent2 = (float)mpu.prevPsi / (float)mpu.getPsiCapacity();
        int color = 1295871;
        int r = RenderHelper.r(color);
        int g = RenderHelper.g(color);
        int b = RenderHelper.b(color);
        Matrix4f mat = ms.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        builder.m_85982_(mat, 6.0f, 126.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.53125f, 0.4140625f).m_85969_(light).m_5752_();
        builder.m_85982_(mat, 18.0f, 126.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.71875f, 0.4140625f).m_85969_(light).m_5752_();
        builder.m_85982_(mat, 18.0f, 20.0f + (1.0f - percent) * 106.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.71875f, (1.0f - percent) * 106.0f / 256.0f).m_85969_(light).m_5752_();
        builder.m_85982_(mat, 6.0f, 20.0f + (1.0f - percent) * 106.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.53125f, (1.0f - percent) * 106.0f / 256.0f).m_85969_(light).m_5752_();
        builder.m_85982_(mat, 6.0f, 20.0f + (1.0f - percent) * 106.0f, 0.0f).m_6122_(r, g, b, 128).m_7421_(0.53125f, (1.0f - percent) * 106.0f / 256.0f).m_85969_(light).m_5752_();
        builder.m_85982_(mat, 18.0f, 20.0f + (1.0f - percent) * 106.0f, 0.0f).m_6122_(r, g, b, 128).m_7421_(0.71875f, (1.0f - percent) * 106.0f / 256.0f).m_85969_(light).m_5752_();
        builder.m_85982_(mat, 18.0f, 20.0f + (1.0f - percent2) * 106.0f, 0.0f).m_6122_(r, g, b, 128).m_7421_(0.71875f, (1.0f - percent2) * 106.0f / 256.0f).m_85969_(light).m_5752_();
        builder.m_85982_(mat, 6.0f, 20.0f + (1.0f - percent2) * 106.0f, 0.0f).m_6122_(r, g, b, 128).m_7421_(0.53125f, (1.0f - percent2) * 106.0f / 256.0f).m_85969_(light).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.m_69481_();
        RenderSystem.m_69461_();
    }

    public void drawRedstoneMode(MPUTile mpu, PoseStack ms, MultiBufferSource buf, int light) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)RedstoneMode.texture);
        RenderSystem.m_69464_();
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GuiComponent.m_93133_((PoseStack)ms, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)(16 * mpu.redstoneMode.ordinal()), (int)16, (int)64, (int)32);
        GuiComponent.m_93133_((PoseStack)ms, (int)(16 * mpu.redstoneMode.ordinal()), (int)0, (float)(16 * mpu.redstoneMode.ordinal()), (float)16.0f, (int)16, (int)16, (int)64, (int)32);
        GuiComponent.m_93133_((PoseStack)ms, (int)(16 * (mpu.redstoneMode.ordinal() + 1)), (int)0, (float)(16 * (mpu.redstoneMode.ordinal() + 1)), (float)0.0f, (int)(64 - 16 * (mpu.redstoneMode.ordinal() + 1)), (int)16, (int)64, (int)32);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69481_();
        RenderSystem.m_69461_();
    }
}

