/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.cable;

import gdavid.phi.cable.ICableConnected;
import gdavid.phi.cable.ICableSegment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CableNetwork {
    @Nullable
    public static BlockPos getController(Level world, BlockPos pos, Direction side) {
        return CableNetwork.getControllerInternal(world, pos, side, true);
    }

    @Nullable
    public static BlockPos getControllerInternal(Level world, BlockPos pos, Direction side, boolean stepDown) {
        BlockPos opos = pos.m_121945_(side);
        BlockEntity tile = world.m_7702_(opos);
        if (tile instanceof ICableSegment) {
            if (((ICableSegment)tile).canConnect(side.m_122424_())) {
                return ((ICableSegment)tile).getConnection();
            }
        } else if (stepDown) {
            if (tile instanceof ICableConnected) {
                if (((ICableConnected)tile).isController()) {
                    return opos;
                }
            } else if (side.m_122434_() != Direction.Axis.Y) {
                return CableNetwork.getControllerInternal(world, pos.m_121945_(Direction.DOWN), side, false);
            }
        }
        return null;
    }

    public static void rebuild(Level world, BlockPos pos) {
        if (world.m_7702_(pos) instanceof ICableSegment) {
            CableNetwork.rebuildInternal(world, pos);
        } else {
            for (Direction dir : Direction.values()) {
                CableNetwork.rebuildInternal(world, pos.m_121945_(dir));
                if (dir.m_122434_() == Direction.Axis.Y) continue;
                CableNetwork.rebuildInternal(world, pos.m_121945_(dir).m_121945_(Direction.UP));
                CableNetwork.rebuildInternal(world, pos.m_121945_(dir).m_121945_(Direction.DOWN));
            }
        }
    }

    static void rebuildInternal(Level world, BlockPos pos) {
        HashSet<BlockPos> matched = new HashSet<BlockPos>();
        ArrayList<ICableSegment> cables = new ArrayList<ICableSegment>();
        BlockPos controller = null;
        boolean valid = true;
        Stack<BlockEntity> s = new Stack<BlockEntity>();
        CableNetwork.tryAdd(s, matched, world, pos);
        while (!s.isEmpty()) {
            BlockEntity tile = s.pop();
            if (tile instanceof ICableSegment) {
                cables.add((ICableSegment)tile);
                for (BlockPos opos : ((ICableSegment)tile).getNeighbours()) {
                    CableNetwork.tryAdd(s, matched, world, opos);
                }
                continue;
            }
            if (!(tile instanceof ICableConnected) || !((ICableConnected)tile).isController()) continue;
            if (controller == null && valid) {
                controller = tile.m_58899_();
                continue;
            }
            valid = false;
            controller = null;
        }
        for (ICableSegment c : cables) {
            c.setConnection(controller, matched::contains);
        }
    }

    static void tryAdd(Stack<BlockEntity> s, HashSet<BlockPos> matched, Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if ((tile instanceof ICableSegment || tile instanceof ICableConnected) && matched.add(pos)) {
            s.push(tile);
        }
    }
}

