/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.capability;

import gdavid.phi.capability.IAccelerationCapability;
import gdavid.phi.capability.ModCapabilities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.psi.api.internal.Vector3;

@Mod.EventBusSubscriber
public class AccelerationCapability
implements IAccelerationCapability,
INBTSerializable<CompoundTag> {
    static final String tagAccelerations = "accelerations";
    static final String tagGravities = "gravities";
    static final String tagPower = "power";
    static final String tagDuration = "duration";
    List<Acceleration> accelerations = new ArrayList<Acceleration>();
    List<AccelerationTowardsPoint> accelerationsTowardsPoint = new ArrayList<AccelerationTowardsPoint>();

    @Override
    public Vector3 getAcceleration(Entity entity) {
        Vector3 res = new Vector3();
        for (Acceleration a : this.accelerations) {
            res.add(a.value);
        }
        for (AccelerationTowardsPoint g : this.accelerationsTowardsPoint) {
            Vector3 diff = g.center.copy().sub(Vector3.fromEntity((Entity)entity));
            double mag = diff.mag();
            res.add(diff.normalize().multiply(Math.min(g.power, mag)));
        }
        return res;
    }

    @Override
    public void addAcceleration(Vector3 acceleration, int duration) {
        this.accelerations.add(new Acceleration(acceleration, duration));
    }

    @Override
    public void addAccelerationTowardsPoint(Vector3 center, double power, int duration) {
        this.accelerationsTowardsPoint.add(new AccelerationTowardsPoint(center, power, duration));
    }

    @Override
    public void tick(Entity entity) {
        int i;
        Vector3 acc = this.getAcceleration(entity);
        if (!entity.f_19853_.f_46443_) {
            entity.m_5997_(acc.x, acc.y, acc.z);
            if (Math.abs(acc.y) > 1.0E-4) {
                if (entity.m_20184_().m_7098_() >= 0.0) {
                    entity.f_19789_ = 0.0f;
                } else if (acc.y > 0.0) {
                    double invTermVel = 0.25510204081632654;
                    double y = entity.m_20184_().m_7098_() * invTermVel + 1.0;
                    if (y > 0.0) {
                        entity.f_19789_ = (float)Math.min((double)entity.f_19789_, Math.max(0.0, -(49.0 / invTermVel) + (49.0 * y - Math.log(y) / Math.log(4.0 * invTermVel)) / invTermVel));
                    }
                }
            }
            if (acc.y > 0.0 && entity instanceof ServerPlayer) {
                ((ServerPlayer)entity).f_8906_.f_9736_ = false;
            }
        } else if (entity instanceof Player) {
            entity.m_5997_(acc.x, acc.y, acc.z);
        }
        for (i = this.accelerations.size() - 1; i >= 0; --i) {
            if (--this.accelerations.get((int)i).duration > 0) continue;
            this.accelerations.remove(i);
        }
        for (i = this.accelerationsTowardsPoint.size() - 1; i >= 0; --i) {
            if (--this.accelerationsTowardsPoint.get((int)i).duration > 0) continue;
            this.accelerationsTowardsPoint.remove(i);
        }
    }

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(new ResourceLocation("phi", "acceleration"), new ModCapabilities.Provider<AccelerationCapability>(ModCapabilities.acceleration, new AccelerationCapability()));
    }

    @SubscribeEvent
    public static void onTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase != TickEvent.Phase.START || !((level = event.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel l = (ServerLevel)level;
        l.m_142646_().m_142273_().forEach(entity -> entity.getCapability(ModCapabilities.acceleration).ifPresent(cap -> cap.tick((Entity)entity)));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().m_91104_()) {
            return;
        }
        Minecraft.m_91087_().f_91074_.getCapability(ModCapabilities.acceleration).ifPresent(cap -> cap.tick((Entity)Minecraft.m_91087_().f_91074_));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag acc = new ListTag();
        for (Acceleration a : this.accelerations) {
            CompoundTag elem = new CompoundTag();
            elem.m_128347_("x", a.value.x);
            elem.m_128347_("y", a.value.y);
            elem.m_128347_("z", a.value.z);
            elem.m_128405_(tagDuration, a.duration);
            acc.add((Object)elem);
        }
        nbt.m_128365_(tagAccelerations, (Tag)acc);
        ListTag grav = new ListTag();
        for (AccelerationTowardsPoint g : this.accelerationsTowardsPoint) {
            CompoundTag elem = new CompoundTag();
            elem.m_128347_("x", g.center.x);
            elem.m_128347_("y", g.center.y);
            elem.m_128347_("z", g.center.z);
            elem.m_128347_(tagPower, g.power);
            elem.m_128405_(tagDuration, g.duration);
            grav.add((Object)elem);
        }
        nbt.m_128365_(tagGravities, (Tag)grav);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag acc = nbt.m_128437_(tagAccelerations, 10);
        this.accelerations = new ArrayList<Acceleration>();
        for (int i = 0; i < acc.size(); ++i) {
            CompoundTag elem = acc.m_128728_(i);
            this.accelerations.add(new Acceleration(new Vector3(elem.m_128459_("x"), elem.m_128459_("y"), elem.m_128459_("z")), elem.m_128451_(tagDuration)));
        }
        ListTag grav = nbt.m_128437_(tagGravities, 10);
        this.accelerationsTowardsPoint = new ArrayList<AccelerationTowardsPoint>();
        for (int i = 0; i < grav.size(); ++i) {
            CompoundTag elem = grav.m_128728_(i);
            this.accelerationsTowardsPoint.add(new AccelerationTowardsPoint(new Vector3(elem.m_128459_("x"), elem.m_128459_("y"), elem.m_128459_("z")), elem.m_128459_(tagPower), elem.m_128451_(tagDuration)));
        }
    }

    static class Acceleration {
        Vector3 value;
        int duration;

        Acceleration(Vector3 value, int duration) {
            this.value = value;
            this.duration = duration;
        }
    }

    static class AccelerationTowardsPoint {
        Vector3 center;
        double power;
        int duration;

        AccelerationTowardsPoint(Vector3 center, double power, int duration) {
            this.center = center;
            this.power = power;
            this.duration = duration;
        }
    }
}

