/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.capability;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.Vector3;

public class MPUCADData
implements ICapabilityProvider,
ICADData,
ISocketable {
    public static final String tagTime = "time";
    public static final String tagMemory = "memory";
    public final ItemStack stack;
    public int time;
    public List<Vector3> vectors = new ArrayList<Vector3>();
    private boolean dirty;

    public MPUCADData(ItemStack stack) {
        this.stack = stack;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == PsiAPI.CAD_DATA_CAPABILITY || cap == PsiAPI.SOCKETABLE_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(tagTime, this.time);
        ListTag memory = new ListTag();
        for (Vector3 vec : this.vectors) {
            memory.add((Object)DoubleTag.m_128500_((double)vec.x));
            memory.add((Object)DoubleTag.m_128500_((double)vec.y));
            memory.add((Object)DoubleTag.m_128500_((double)vec.z));
        }
        nbt.m_128365_(tagMemory, (Tag)memory);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.time = nbt.m_128451_(tagTime);
        ListTag memory = nbt.m_128437_(tagMemory, 6);
        for (int i = 0; i < memory.size() / 3; ++i) {
            this.vectors.add(new Vector3(memory.m_128772_(i * 3), memory.m_128772_(i * 3 + 1), memory.m_128772_(i * 3 + 2)));
        }
    }

    public boolean isSocketSlotAvailable(int slot) {
        return false;
    }

    public ItemStack getBulletInSocket(int slot) {
        return ItemStack.f_41583_;
    }

    public void setBulletInSocket(int slot, ItemStack bullet) {
    }

    public int getSelectedSlot() {
        return 0;
    }

    public void setSelectedSlot(int slot) {
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getBattery() {
        return 0;
    }

    public void setBattery(int battery) {
    }

    public Vector3 getSavedVector(int memorySlot) {
        if (memorySlot < 0 || memorySlot >= this.vectors.size()) {
            return Vector3.zero;
        }
        return this.vectors.get(memorySlot);
    }

    public void setSavedVector(int memorySlot, Vector3 value) {
        while (this.vectors.size() <= memorySlot) {
            this.vectors.add(Vector3.zero);
        }
        this.vectors.set(memorySlot, value);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    public CompoundTag serializeForSynchronization() {
        return null;
    }
}

