/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.spell.ISpellAcceptor;

public class MagazineSocketable
implements ICapabilityProvider,
ISocketable {
    final ItemStack item;
    public int slots;

    public MagazineSocketable(ItemStack item, int slots) {
        this.item = item;
        this.slots = slots;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (capability == PsiAPI.SOCKETABLE_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return LazyOptional.empty();
    }

    public boolean isSocketSlotAvailable(int slot) {
        return slot < this.slots;
    }

    public ItemStack getBulletInSocket(int slot) {
        CompoundTag nbt = this.item.m_41698_("slot").m_128469_(Integer.toString(slot));
        if (nbt.m_128456_()) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)nbt);
    }

    public void setBulletInSocket(int slot, ItemStack bullet) {
        CompoundTag nbt = new CompoundTag();
        if (!bullet.m_41619_()) {
            bullet.m_41739_(nbt);
        }
        this.item.m_41698_("slot").m_128365_(Integer.toString(slot), (Tag)nbt);
    }

    public int getSelectedSlot() {
        return 0;
    }

    public void setSelectedSlot(int slot) {
    }

    public int getLastSlot() {
        return this.slots - 1;
    }

    public boolean isItemValid(int slot, ItemStack bullet) {
        return this.isSocketSlotAvailable(slot) && ISpellAcceptor.isContainer((ItemStack)bullet);
    }
}

